import { aws_stepfunctions as stepfunctions } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { LambdaAccess } from './access';
import { Secrets } from './secrets';
import { WebhookHandlerFunction } from './webhook-handler-function';
/**
 * @internal
 */
export interface SupportedLabels {
    readonly provider: string;
    readonly labels: string[];
}
/**
 * Properties for GithubWebhookHandler
 *
 * @internal
 */
export interface GithubWebhookHandlerProps {
    /**
     * Step function in charge of handling the workflow job events and start the runners.
     */
    readonly orchestrator: stepfunctions.StateMachine;
    /**
     * Secrets used to communicate with GitHub.
     */
    readonly secrets: Secrets;
    /**
     * Configure access to webhook function.
     */
    readonly access?: LambdaAccess;
    /**
     * List of supported label combinations.
     */
    readonly supportedLabels: SupportedLabels[];
    /**
     * Whether to require the "self-hosted" label.
     */
    readonly requireSelfHostedLabel: boolean;
}
/**
 * Create a Lambda with a public URL to handle GitHub webhook events. After validating the event with the given secret, the orchestrator step function is called with information about the workflow job.
 *
 * @internal
 */
export declare class GithubWebhookHandler extends Construct {
    /**
     * Public URL of webhook to be used with GitHub.
     */
    readonly url: string;
    /**
     * Webhook event handler.
     */
    readonly handler: WebhookHandlerFunction;
    constructor(scope: Construct, id: string, props: GithubWebhookHandlerProps);
}
