"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secrets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Secrets required for GitHub runners operation.
 */
class Secrets extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.webhook = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Webhook', {
            generateSecretString: {
                secretStringTemplate: '{}',
                generateStringKey: 'webhookSecret',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        this.github = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    domain: 'github.com',
                    appId: '',
                    personalAuthToken: '',
                    // we can't uncomment the following because changing the template overrides existing values on version upgrade :(
                    // runnerLevel: 'repo'
                }),
                generateStringKey: 'dummy',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        // we create a separate secret for the private key because putting it in JSON secret is hard for the user
        this.githubPrivateKey = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub Private Key', {
            secretStringValue: cdk.SecretValue.unsafePlainText('-----BEGIN RSA PRIVATE KEY-----\n...\n-----END RSA PRIVATE KEY-----'),
        });
        this.setup = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Setup', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    token: '',
                }),
                generateStringKey: 'token',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
    }
}
exports.Secrets = Secrets;
_a = JSII_RTTI_SYMBOL_1;
Secrets[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.Secrets", version: "0.14.15" };
//# sourceMappingURL=data:application/json;base64,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