"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const client_lambda_1 = require("@aws-sdk/client-lambda");
const lambda = new client_lambda_1.LambdaClient();
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
async function handler(event) {
    console.log(event);
    while (true) {
        try {
            await lambda.send(new client_lambda_1.UpdateFunctionCodeCommand({
                FunctionName: event.lambdaName,
                ImageUri: `${event.repositoryUri}:${event.repositoryTag}`,
                Publish: true,
            }));
            break;
        }
        catch (e) {
            if (e instanceof client_lambda_1.ResourceConflictException) {
                // keep trying if function is already being updated by CloudFormation
                // this can happen if we update some settings on the function and the image code at the same time
                await sleep(10000);
            }
            else {
                throw e;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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