"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const client_codebuild_1 = require("@aws-sdk/client-codebuild");
const lambda_helpers_1 = require("../lambda-helpers");
const codebuild = new client_codebuild_1.CodeBuildClient();
async function handler(event, context) {
    try {
        console.log({ ...event, ResponseURL: '...' });
        const props = event.ResourceProperties;
        switch (event.RequestType) {
            case 'Create':
            case 'Update':
                console.log(`Starting CodeBuild project ${props.ProjectName}`);
                const cbRes = await codebuild.send(new client_codebuild_1.StartBuildCommand({
                    projectName: props.ProjectName,
                    environmentVariablesOverride: [
                        {
                            type: 'PLAINTEXT',
                            name: 'WAIT_HANDLE',
                            value: props.WaitHandle,
                        },
                    ],
                }));
                await (0, lambda_helpers_1.customResourceRespond)(event, 'SUCCESS', 'OK', cbRes.build?.id ?? 'build', {});
                break;
            case 'Delete':
                await (0, lambda_helpers_1.customResourceRespond)(event, 'SUCCESS', 'OK', event.PhysicalResourceId, {});
                break;
        }
    }
    catch (e) {
        console.error(e);
        await (0, lambda_helpers_1.customResourceRespond)(event, 'FAILED', e.message || 'Internal Error', context.logStreamName, {});
    }
}
//# sourceMappingURL=data:application/json;base64,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