"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImageBuilderObjectBase = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const versioner_function_1 = require("./versioner-function");
const utils_1 = require("../../utils");
/**
 * @internal
 */
class ImageBuilderObjectBase extends cdk.Resource {
    constructor(scope, id) {
        super(scope, id);
    }
    generateVersion(type, name, data) {
        return new aws_cdk_lib_1.CustomResource(this, 'Version', {
            serviceToken: this.versionFunction().functionArn,
            resourceType: `Custom::ImageBuilder-${type}-Version`,
            removalPolicy: cdk.RemovalPolicy.RETAIN, // no point in deleting as it doesn't even create anything
            properties: {
                ObjectType: type,
                ObjectName: name,
                VersionedData: data, // get a new version every time something changes, like Image Builder wants
            },
        }).ref;
    }
    versionFunction() {
        return (0, utils_1.singletonLambda)(versioner_function_1.VersionerFunction, this, 'aws-image-builder-versioner', {
            description: 'Custom resource handler that bumps up Image Builder versions',
            initialPolicy: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    actions: [
                        'imagebuilder:ListComponents',
                        'imagebuilder:ListContainerRecipes',
                        'imagebuilder:ListImageRecipes',
                        'imagebuilder:ListWorkflows',
                    ],
                    resources: ['*'],
                }),
            ],
            logGroup: (0, utils_1.singletonLogGroup)(this, utils_1.SingletonLogType.RUNNER_IMAGE_BUILD),
            loggingFormat: aws_cdk_lib_1.aws_lambda.LoggingFormat.JSON,
            timeout: cdk.Duration.minutes(5),
        });
    }
}
exports.ImageBuilderObjectBase = ImageBuilderObjectBase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2ltYWdlLWJ1aWxkZXJzL2F3cy1pbWFnZS1idWlsZGVyL2NvbW1vbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxtQ0FBbUM7QUFDbkMsNkNBQW1GO0FBRW5GLDZEQUF5RDtBQUN6RCx1Q0FBbUY7QUFFbkY7O0dBRUc7QUFDSCxNQUFzQixzQkFBdUIsU0FBUSxHQUFHLENBQUMsUUFBUTtJQUMvRCxZQUFzQixLQUFnQixFQUFFLEVBQVU7UUFDaEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztJQUNuQixDQUFDO0lBRVMsZUFBZSxDQUFDLElBQWtFLEVBQUUsSUFBWSxFQUFFLElBQVM7UUFDbkgsT0FBTyxJQUFJLDRCQUFjLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUN6QyxZQUFZLEVBQUUsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDLFdBQVc7WUFDaEQsWUFBWSxFQUFFLHdCQUF3QixJQUFJLFVBQVU7WUFDcEQsYUFBYSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsTUFBTSxFQUFFLDBEQUEwRDtZQUNuRyxVQUFVLEVBQUU7Z0JBQ1YsVUFBVSxFQUFFLElBQUk7Z0JBQ2hCLFVBQVUsRUFBRSxJQUFJO2dCQUNoQixhQUFhLEVBQUUsSUFBSSxFQUFFLDJFQUEyRTthQUNqRztTQUNGLENBQUMsQ0FBQyxHQUFHLENBQUM7SUFDVCxDQUFDO0lBRU8sZUFBZTtRQUNyQixPQUFPLElBQUEsdUJBQWUsRUFBQyxzQ0FBaUIsRUFBRSxJQUFJLEVBQUUsNkJBQTZCLEVBQUU7WUFDN0UsV0FBVyxFQUFFLDhEQUE4RDtZQUMzRSxhQUFhLEVBQUU7Z0JBQ2IsSUFBSSxxQkFBRyxDQUFDLGVBQWUsQ0FBQztvQkFDdEIsT0FBTyxFQUFFO3dCQUNQLDZCQUE2Qjt3QkFDN0IsbUNBQW1DO3dCQUNuQywrQkFBK0I7d0JBQy9CLDRCQUE0QjtxQkFDN0I7b0JBQ0QsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO2lCQUNqQixDQUFDO2FBQ0g7WUFDRCxRQUFRLEVBQUUsSUFBQSx5QkFBaUIsRUFBQyxJQUFJLEVBQUUsd0JBQWdCLENBQUMsa0JBQWtCLENBQUM7WUFDdEUsYUFBYSxFQUFFLHdCQUFNLENBQUMsYUFBYSxDQUFDLElBQUk7WUFDeEMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztTQUNqQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFyQ0Qsd0RBcUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IGF3c19pYW0gYXMgaWFtLCBhd3NfbGFtYmRhIGFzIGxhbWJkYSwgQ3VzdG9tUmVzb3VyY2UgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFZlcnNpb25lckZ1bmN0aW9uIH0gZnJvbSAnLi92ZXJzaW9uZXItZnVuY3Rpb24nO1xuaW1wb3J0IHsgc2luZ2xldG9uTGFtYmRhLCBzaW5nbGV0b25Mb2dHcm91cCwgU2luZ2xldG9uTG9nVHlwZSB9IGZyb20gJy4uLy4uL3V0aWxzJztcblxuLyoqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEltYWdlQnVpbGRlck9iamVjdEJhc2UgZXh0ZW5kcyBjZGsuUmVzb3VyY2Uge1xuICBwcm90ZWN0ZWQgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gIH1cblxuICBwcm90ZWN0ZWQgZ2VuZXJhdGVWZXJzaW9uKHR5cGU6ICdDb21wb25lbnQnIHwgJ0ltYWdlUmVjaXBlJyB8ICdDb250YWluZXJSZWNpcGUnIHwgJ1dvcmtmbG93JywgbmFtZTogc3RyaW5nLCBkYXRhOiBhbnkpOiBzdHJpbmcge1xuICAgIHJldHVybiBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ1ZlcnNpb24nLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IHRoaXMudmVyc2lvbkZ1bmN0aW9uKCkuZnVuY3Rpb25Bcm4sXG4gICAgICByZXNvdXJjZVR5cGU6IGBDdXN0b206OkltYWdlQnVpbGRlci0ke3R5cGV9LVZlcnNpb25gLFxuICAgICAgcmVtb3ZhbFBvbGljeTogY2RrLlJlbW92YWxQb2xpY3kuUkVUQUlOLCAvLyBubyBwb2ludCBpbiBkZWxldGluZyBhcyBpdCBkb2Vzbid0IGV2ZW4gY3JlYXRlIGFueXRoaW5nXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIE9iamVjdFR5cGU6IHR5cGUsXG4gICAgICAgIE9iamVjdE5hbWU6IG5hbWUsXG4gICAgICAgIFZlcnNpb25lZERhdGE6IGRhdGEsIC8vIGdldCBhIG5ldyB2ZXJzaW9uIGV2ZXJ5IHRpbWUgc29tZXRoaW5nIGNoYW5nZXMsIGxpa2UgSW1hZ2UgQnVpbGRlciB3YW50c1xuICAgICAgfSxcbiAgICB9KS5yZWY7XG4gIH1cblxuICBwcml2YXRlIHZlcnNpb25GdW5jdGlvbigpOiBWZXJzaW9uZXJGdW5jdGlvbiB7XG4gICAgcmV0dXJuIHNpbmdsZXRvbkxhbWJkYShWZXJzaW9uZXJGdW5jdGlvbiwgdGhpcywgJ2F3cy1pbWFnZS1idWlsZGVyLXZlcnNpb25lcicsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiAnQ3VzdG9tIHJlc291cmNlIGhhbmRsZXIgdGhhdCBidW1wcyB1cCBJbWFnZSBCdWlsZGVyIHZlcnNpb25zJyxcbiAgICAgIGluaXRpYWxQb2xpY3k6IFtcbiAgICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAgICdpbWFnZWJ1aWxkZXI6TGlzdENvbXBvbmVudHMnLFxuICAgICAgICAgICAgJ2ltYWdlYnVpbGRlcjpMaXN0Q29udGFpbmVyUmVjaXBlcycsXG4gICAgICAgICAgICAnaW1hZ2VidWlsZGVyOkxpc3RJbWFnZVJlY2lwZXMnLFxuICAgICAgICAgICAgJ2ltYWdlYnVpbGRlcjpMaXN0V29ya2Zsb3dzJyxcbiAgICAgICAgICBdLFxuICAgICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICAgIH0pLFxuICAgICAgXSxcbiAgICAgIGxvZ0dyb3VwOiBzaW5nbGV0b25Mb2dHcm91cCh0aGlzLCBTaW5nbGV0b25Mb2dUeXBlLlJVTk5FUl9JTUFHRV9CVUlMRCksXG4gICAgICBsb2dnaW5nRm9ybWF0OiBsYW1iZGEuTG9nZ2luZ0Zvcm1hdC5KU09OLFxuICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLm1pbnV0ZXMoNSksXG4gICAgfSk7XG4gIH1cbn1cblxuIl19