# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tests']

package_data = \
{'': ['*']}

modules = \
['vault2vault']
install_requires = \
['ruamel.yaml>=0.17.16,<0.18.0']

extras_require = \
{'ansible': ['ansible-core>=2.11.5,<3.0.0']}

entry_points = \
{'console_scripts': ['vault2vault = vault2vault:main']}

setup_kwargs = {
    'name': 'vault2vault',
    'version': '0.1.2',
    'description': 'Recursively rekey ansible-vault encrypted files and in-line variables',
    'long_description': '# vault2vault\n\nLike\n[`ansible-vault rekey`](https://docs.ansible.com/ansible/latest/cli/ansible-vault.html#rekey)\nbut works recursively on encrypted files and in-line variables\n\n[![CI Status](https://github.com/enpaul/vault2vault/workflows/CI/badge.svg?event=push)](https://github.com/enpaul/vault2vault/actions)\n[![PyPI Version](https://img.shields.io/pypi/v/vault2vault)](https://pypi.org/project/vault2vault/)\n[![License](https://img.shields.io/pypi/l/vault2vault)](https://opensource.org/licenses/MIT)\n[![Python Supported Versions](https://img.shields.io/pypi/pyversions/vault2vault)](https://www.python.org)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n⚠️ **This project is beta software and is under active development** ⚠️\n\n- [What is this?](#what-is-this)\n- [Installing](#installing)\n- [Usage](#usage)\n  - [Recovering from a failed migration](#recovering-from-a-failed-migration)\n- [Roadmap](#roadmap)\n- [Developing](#developer-documentation)\n\n## What is this?\n\nIf you use [Ansible Vault](https://docs.ansible.com/ansible/latest/user_guide/vault.html)\nthen you may have encountered the problem of needing to roll your vault password. Maybe\nyou found it written down on a sticky note, maybe a coworker who knows it left the\ncompany, maybe you accidentally typed it into Slack when you thought the focus was on your\nterminal. Whatever, these things happen.\n\nThe built-in tool Ansible provides,\n[`ansible-vault rekey`](https://docs.ansible.com/ansible/latest/cli/ansible-vault.html#rekey),\nsuffers from two main drawbacks: first, it only works on vault encrypted files and not on\nvault encrypted YAML data; and second, it only works on a single vault encrypted file at\na time. To rekey everything in a large project you\'d need to write a script that\nrecursively goes through every file and rekeys every encrypted file and YAML variable all\nat once.\n\nThis is that script.\n\n## Installing\n\nIf you\'re using [Poetry](https://python-poetry.org/) or\n[Pipenv](https://pipenv.pypa.io/en/latest/) to manage your Ansible runtime environment,\nyou can just add `vault2vault` to that same environment:\n\n```\n# using poetry\npoetry add vault2vault --dev\n\n# using pipenv\npipenv install vault2vault\n```\n\nIf you\'re using Ansible from your system package manager, it\'s probably easier to just\ninstall `vault2vault` using [PipX](https://pypa.github.io/pipx/) and the `ansible` extra:\n\n```\npipx install vault2vault[ansible]\n```\n\n> Note: vault2vault requires an Ansible installation to function. If you are installing to a\n> standalone virtual environment (like with PipX) then you must install it with the\n> `ansible` extra to ensure a version of Ansible is available to the application.\\*\\*\n\n## Usage\n\n> Note: the full command reference is available by running `vault2vault --help`\n\nVault2Vault works with files in any arbitrary directory structures, so there is no need to\nhave your Ansible project(s) structured in a specific way for the tool to work. The\nsimplest usage of Vault2Vault is by passing the path to your Ansible project directory to\nthe command:\n\n```bash\nvault2vault ./my-ansible-project/\n```\n\nThe tool will prompt for the current vault password and the new vault password and then\nprocess every file under the provided path. You can also specify multiple paths and\nthey\'ll all be processed together:\n\n```bash\nvault2vault \\\n  ./my-ansible-project/playbooks/ \\\n  ./my-ansible-project/host_vars/ \\\n  ./my-ansible-project/group_vars/\n```\n\nTo skip the interactive password prompts you can put the password in a file and have the\ntool read it in at runtime. The `--old-pass-file` and `--new-pass-file` parameters work\nthe same way as the `--vault-password-file` option from the `ansible` command:\n\n```bash\nvault2vault ./my-ansible-project/ \\\n  --old-pass-file=./oldpass.txt \\\n  --new-pass-file=./newpass.txt\n```\n\nIf you use multiple vault passwords in your project and want to roll them you\'ll need to\nrun `vault2vault` once for each password you want to change. By default, `vault2vault`\nwill fail with an error if it encounters vaulted data that it cannot decrypt with the\nprovided current vault password. To change this behavior and instead just ignore any\nvaulted data that can\'t be decrypted (like, for example, if you have data encrypted with\nmultiple vault passwords) you can pass the `--ignore-undecryptable` flag to turn the\nerrors into warnings.\n\n> Please report any bugs or issues you encounter on\n> [Github](https://github.com/enpaul/vault2vault/issues).\n\n### Recovering from a failed migration\n\nThis tool is still pretty early in it\'s development, and to be honest it hooks into\nAnsible\'s functionality in some fragile ways. I\'ve tested as best I can to ensure it\ncovers as many edge cases as possible, but there is still the chance that you might get\npartway through a password migration and then have the tool fail out, leaving half of your\ndata successfully rekeyed and the other half not.\n\nIn the spirit of the\n[Unix philosophy](https://hackaday.com/2018/09/10/doing-one-thing-well-the-unix-philosophy/)\nthis tool does not include any built-in way to recover from this state. However, it can\nbe done very effectively using a version control tool.\n\nIf you are using Git to track your project files then you can use the command\n`git reset --hard` to restore all files to the state of the currently checked out commit.\nThis does have the side effect of erasing any other un-committed work in the repository,\nso it\'s recommended to always have a clean working tree when using Vault2Vault.\n\nIf you are not using a version control system to track your project files then you can\ncreate a temporary Git repository to use in the event of a migration failure:\n\n```bash\ncd my-project/\n\n# Initialize the new repository\ngit init\n\n# Add and commit all your existing files to the git tree\ngit add .\ngit commit -m "initial commit"\n\n# Run vault migrations\nvault2vault ...\n\n# If no recovery is necessary, delete the git repository data\nrm -rf .git\n```\n\n## Roadmap\n\nThis project is considered feature complete as of the\n[0.1.1](https://github.com/enpaul/vault2vault/releases/tag/0.1.1) release. As a result the\nroadmap focuses on stability and user experience ahead of a 1.0 release.\n\n- [ ] Reimplement core vaulted data processing function to enable multithreading\n- [ ] Implement multithreading for performance in large environments\n- [ ] Add unit tests\n- [ ] Add integration tests\n- [ ] Redesign logging messages to improve clarity and consistency\n\n## Developer Documentation\n\nAll project contributors and participants are expected to adhere to the\n[Contributor Covenant Code of Conduct, v2](CODE_OF_CONDUCT.md) ([external link](https://www.contributor-covenant.org/version/2/0/code_of_conduct/)).\n\nThe `devel` branch has the latest (and potentially unstable) changes. The stable releases\nare tracked on [Github](https://github.com/enpaul/vault2vault/releases),\n[PyPi](https://pypi.org/project/vault2vault/#history), and in the\n[Changelog](CHANGELOG.md).\n\n- To report a bug, request a feature, or ask for assistance, please\n  [open an issue on the Github repository](https://github.com/enpaul/vault2vault/issues/new).\n- To report a security concern or code of conduct violation, please contact the project\n  author directly at **\u200cme \\[at\u200c\\] enp dot\u200e \u200cone**.\n- To submit an update, please\n  [fork the repository](https://docs.github.com/en/enterprise/2.20/user/github/getting-started-with-github/fork-a-repo)\n  and [open a pull request](https://github.com/enpaul/vault2vault/compare).\n\nDeveloping this project requires [Python 3.7+](https://www.python.org/downloads/) and\n[Poetry 1.0](https://python-poetry.org/docs/#installation) or later. GNU Make can\noptionally be used to quickly setup a local development environment, but this is not\nrequired.\n\nTo setup a local development environment:\n\n```bash\n# Clone the repository...\n# ...over HTTPS\ngit clone https://github.com/enpaul/vault2vault.git\n# ...over SSH\ngit clone git@github.com:enpaul/vault2vault.git\n\ncd vault2vault/\n\n# Create and configure the local development environment...\nmake dev\n\n# Run tests and CI locally...\nmake test\n\n# See additional make targets\nmake help\n```\n',
    'author': 'Ethan Paul',
    'author_email': '24588726+enpaul@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/enpaul/vault2vault/',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
