# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
from .type import Type
import typing
from .validation_result import ValidationResult
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Symbol(UniversalBaseModel):
    """
    Represents a mathematical or physical symbol with its properties.

    Examples:
        >>> symbol = Symbol(
        ...     name="velocity",
        ...     wolfram_format="v",
        ...     latex_representation="\vec{v}",
        ...     dimension="meters/second",
        ...     description="Velocity of an object",
        ...     type="vector",
        ...     validations={},
        ... )

        >>> symbol = Symbol(
        ...     name="acceleration",
        ...     wolfram_format="a",
        ...     latex_representation="\vec{a}",
        ...     dimension="length * second^-2",
        ...     description="Rate of change of velocity",
        ...     type="vector",
        ...     validations={},
        ... )
    """

    name: str = pydantic.Field()
    """
    Name of the symbol, e.g., 'velocity', 'acceleration'
    """

    wolfram_format: str = pydantic.Field()
    """
    Wolfram Alpha format of the symbol
    """

    latex_representation: str = pydantic.Field()
    """
    LaTeX representation of the symbol
    """

    dimension: str = pydantic.Field()
    """
    Physical dimension as a string, e.g., 'meters/second', 'length * second^2'
    """

    description: str = pydantic.Field()
    """
    Detailed description of the symbol
    """

    type: Type = pydantic.Field()
    """
    Mathematical type of the symbol
    """

    validations: typing.Dict[str, ValidationResult] = pydantic.Field()
    """
    List of validation results for the symbol, key is validator's name
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
