# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .computation import Computation
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class PicZ3Expression(UniversalBaseModel):
    """
    The model for a Z3 expression related to PIC.
    This is a subclass of Z3Expression, which is a model for a Z3 expression.
    The validation is such that an instance contains a code that can be parsed into a z3 expression and, if mapping is set, it contains a valid Computation for every variable in the expression.
    It does not check if the expression can be evaluated, this depends on the target Netlist.
    """

    code: str = pydantic.Field()
    """
    A string with the z3 expression.
    """

    default_tolerance: typing.Optional[float] = pydantic.Field(default=None)
    """
    The tolerance to be used when comparing the expression with a value.
    """

    mapping: typing.Optional[typing.Dict[str, typing.Optional[Computation]]] = pydantic.Field(default=None)
    """
    A mapping of the variables used in the expression to Computations.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
