# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .bounds import Bounds
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Parameter(UniversalBaseModel):
    """
    A parameter to optimize with its bounds and path in the settings dictionary
    """

    path: str = pydantic.Field()
    """
    Path to the parameter in the netlist in the format 'instance_name,parameter_name'
    """

    bounds: typing.Optional[Bounds] = pydantic.Field(default=None)
    """
    Lower and upper bounds of the parameter
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
