# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ExtractedPoint(UniversalBaseModel):
    """
    Represents a single extracted point from the plot.
    """

    value_x: float = pydantic.Field()
    """
    X-axis value of the extracted point.
    """

    value_y: float = pydantic.Field()
    """
    Y-axis value of the extracted point.
    """

    img_coord_x: typing.Optional[float] = pydantic.Field(default=None)
    """
    X coordinate in the image.
    """

    img_coord_y: typing.Optional[float] = pydantic.Field(default=None)
    """
    Y coordinate in the image.
    """

    percentage_coord_x: typing.Optional[float] = pydantic.Field(default=None)
    """
    X coordinate in the image as a percentage of img width
    """

    percentage_coord_y: typing.Optional[float] = pydantic.Field(default=None)
    """
    Y coordinate in the image as a percentage of img height
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
