# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .symbol import Symbol
from .validation_result import ValidationResult
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Expression(UniversalBaseModel):
    """
    Represents a mathematical or physical expression with its properties and validation.

    Examples:
        >>> newton_law = Expression(
        ...     name="Newton's Second Law",
        ...     description="The force equals mass times acceleration",
        ...     original_format="F = ma",
        ...     wolfram_expression="F == m*a",
        ...     symbols={
        ...         "F": Symbol(
        ...             name="force",
        ...             wolfram_format="F",
        ...             latex_representation="\vec{F}",
        ...             dimension="mass * length * second^-2",
        ...             description="Net force acting on the object",
        ...             type="vector"
        ...         ),
        ...         "m": Symbol(
        ...             name="mass",
        ...             wolfram_format="m",
        ...             latex_representation="m",
        ...             dimension="mass",
        ...             description="Mass of the object",
        ...             type="scalar"
        ...         )
        ...     },
        ...     narrative_assumptions=[
        ...         "Object is treated as a point mass",
        ...         "Forces are in an inertial reference frame"
        ...     ],
        ...     validation={
        ...         "dimensions": ValidationResult(
        ...             is_valid=True,
        ...             message="Dimensions match on both sides"
        ...         )
        ...     }
        ... )
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the expression
    """

    name: str = pydantic.Field()
    """
    Human-readable name of the Expression (e.g., 'Newton's Law')
    """

    description: str = pydantic.Field()
    """
    Text describing the Expression
    """

    original_format: str = pydantic.Field()
    """
    Original form of the Expression (e.g., LaTeX)
    """

    wolfram_expression: str = pydantic.Field()
    """
    Expression in Wolfram Language (or other symbolic form)
    """

    symbols: typing.Dict[str, Symbol] = pydantic.Field()
    """
    Dictionary mapping symbol names to their Symbol objects
    """

    narrative_assumptions: typing.List[str] = pydantic.Field()
    """
    Narrative text describing assumptions/approximations
    """

    exp_validations: typing.Dict[str, ValidationResult] = pydantic.Field()
    """
    Dictionary mapping validation types to their results
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
