# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
from .port_instance_layout_info import PortInstanceLayoutInfo
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic


class ComponentInstanceLayoutInfo(UniversalBaseModel):
    """
    Class to represent layout information of a component in a circuit.
    This information is only obtained from the code, not from the PDK.

    Note that this data is NOT the same as the placement data in the Netlist.
    Note that this data is NOT the same as the component_info data in the Netlist.
    """

    component: str
    center_x: float
    center_y: float
    size_x: float
    size_y: float
    ports: typing.Dict[str, PortInstanceLayoutInfo]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
