# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.parse_statement_response import ParseStatementResponse
from ...core.pydantic_utilities import parse_obj_as
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from .types.statement import Statement
from ...types.informalize_statement_response import InformalizeStatementResponse
from ...core.serialization import convert_and_respect_annotation_metadata
from ...types.netlist import Netlist
from ...types.statement_dictionary import StatementDictionary
from ...types.computation import Computation
from ...types.validate_netlist_response import ValidateNetlistResponse
from ...types.pdk_type import PdkType
from ...types.formalize_circuit_response import FormalizeCircuitResponse
from ...types.find_mapping_response import FindMappingResponse
from ...types.generate_code_response import GenerateCodeResponse
from ...types.refine_code_response import RefineCodeResponse
from ...types.parameter import Parameter
from ...types.optimize_config import OptimizeConfig
from ...types.optimize_netlist_response import OptimizeNetlistResponse
from ...types.optimize_placement_body_response import OptimizePlacementBodyResponse
from ...types.verify_circuit_code_response import VerifyCircuitCodeResponse
from .types.settings import Settings
from ...types.get_spectrum_response import GetSpectrumResponse
from ...types.get_optimizable_parameters_response import GetOptimizableParametersResponse
from ...types.update_code_response import UpdateCodeResponse
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CircuitClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def parse(
        self,
        *,
        text: str,
        informalize: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParseStatementResponse:
        """
        Parse a piece of text into a valid formal statement, if possible.

        Parameters
        ----------
        text : str

        informalize : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParseStatementResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.parse(
            text="text",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/statement/parse",
            method="POST",
            json={
                "text": text,
                "informalize": informalize,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ParseStatementResponse,
                    parse_obj_as(
                        type_=ParseStatementResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def informalize(
        self, *, statement: Statement, request_options: typing.Optional[RequestOptions] = None
    ) -> InformalizeStatementResponse:
        """
        Informalize a formal statement about a circuit into a natural language text.

        Parameters
        ----------
        statement : Statement

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InformalizeStatementResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, ParameterConstraint

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.informalize(
            statement=ParameterConstraint(
                text="text",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/statement/informalize",
            method="POST",
            json={
                "statement": convert_and_respect_annotation_metadata(
                    object_=statement, annotation=Statement, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    InformalizeStatementResponse,
                    parse_obj_as(
                        type_=InformalizeStatementResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def validate(
        self,
        *,
        netlist: Netlist,
        statements: StatementDictionary,
        mapping: typing.Optional[typing.Dict[str, typing.Optional[Computation]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ValidateNetlistResponse:
        """
        Validates a set of statements against a netlist.

        Parameters
        ----------
        netlist : Netlist

        statements : StatementDictionary

        mapping : typing.Optional[typing.Dict[str, typing.Optional[Computation]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidateNetlistResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, Netlist, StatementDictionary

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.validate(
            netlist=Netlist(),
            statements=StatementDictionary(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/validate",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
                "mapping": convert_and_respect_annotation_metadata(
                    object_=mapping, annotation=typing.Dict[str, typing.Optional[Computation]], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ValidateNetlistResponse,
                    parse_obj_as(
                        type_=ValidateNetlistResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def formalize(
        self,
        *,
        query: str,
        pdk: typing.Optional[PdkType] = OMIT,
        statements: typing.Optional[StatementDictionary] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FormalizeCircuitResponse:
        """
        Formalize a query about a circuit into a dictionary of constraints. Extends previous statements if provided.

        Parameters
        ----------
        query : str

        pdk : typing.Optional[PdkType]

        statements : typing.Optional[StatementDictionary]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FormalizeCircuitResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.formalize(
            query="query",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/query/formalize",
            method="POST",
            json={
                "query": query,
                "pdk": pdk,
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FormalizeCircuitResponse,
                    parse_obj_as(
                        type_=FormalizeCircuitResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def mapping(
        self,
        *,
        statements: StatementDictionary,
        netlist: Netlist,
        max_iter: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindMappingResponse:
        """
        Map variables in the constraints to computations on the netlist.

        Parameters
        ----------
        statements : StatementDictionary

        netlist : Netlist

        max_iter : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindMappingResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, Netlist, StatementDictionary

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.mapping(
            statements=StatementDictionary(),
            netlist=Netlist(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/mapping/find",
            method="POST",
            params={
                "max_iter": max_iter,
            },
            json={
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FindMappingResponse,
                    parse_obj_as(
                        type_=FindMappingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def generate(
        self,
        *,
        query: str,
        max_iterations: typing.Optional[int] = OMIT,
        llm_model: typing.Optional[str] = OMIT,
        apply_orientation: typing.Optional[bool] = OMIT,
        apply_placement: typing.Optional[bool] = OMIT,
        apply_routing: typing.Optional[bool] = OMIT,
        return_cell: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateCodeResponse:
        """
        Generate GDS factory code to create a circuit

        Parameters
        ----------
        query : str

        max_iterations : typing.Optional[int]

        llm_model : typing.Optional[str]

        apply_orientation : typing.Optional[bool]

        apply_placement : typing.Optional[bool]

        apply_routing : typing.Optional[bool]

        return_cell : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateCodeResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.generate(
            query="query",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/generate",
            method="POST",
            json={
                "query": query,
                "max_iterations": max_iterations,
                "llm_model": llm_model,
                "apply_orientation": apply_orientation,
                "apply_placement": apply_placement,
                "apply_routing": apply_routing,
                "return_cell": return_cell,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GenerateCodeResponse,
                    parse_obj_as(
                        type_=GenerateCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def refine(
        self,
        *,
        query: str,
        max_iterations: typing.Optional[int] = OMIT,
        feedback: typing.Optional[str] = OMIT,
        code: typing.Optional[str] = OMIT,
        llm_model: typing.Optional[str] = OMIT,
        apply_orientation: typing.Optional[bool] = OMIT,
        apply_placement: typing.Optional[bool] = OMIT,
        apply_routing: typing.Optional[bool] = OMIT,
        return_cell: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RefineCodeResponse:
        """
        Refine GDS factory code to create a circuit

        Parameters
        ----------
        query : str

        max_iterations : typing.Optional[int]

        feedback : typing.Optional[str]

        code : typing.Optional[str]

        llm_model : typing.Optional[str]

        apply_orientation : typing.Optional[bool]

        apply_placement : typing.Optional[bool]

        apply_routing : typing.Optional[bool]

        return_cell : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RefineCodeResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.refine(
            query="query",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/refine",
            method="POST",
            json={
                "query": query,
                "max_iterations": max_iterations,
                "feedback": feedback,
                "code": code,
                "llm_model": llm_model,
                "apply_orientation": apply_orientation,
                "apply_placement": apply_placement,
                "apply_routing": apply_routing,
                "return_cell": return_cell,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RefineCodeResponse,
                    parse_obj_as(
                        type_=RefineCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def optimize(
        self,
        *,
        netlist: Netlist,
        statements: StatementDictionary,
        parameters: typing.Optional[typing.Sequence[Parameter]] = OMIT,
        mapping: typing.Optional[typing.Dict[str, typing.Optional[Computation]]] = OMIT,
        config: typing.Optional[OptimizeConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptimizeNetlistResponse:
        """
        Optimize a PIC circuit with given cost and constraints

        Parameters
        ----------
        netlist : Netlist

        statements : StatementDictionary

        parameters : typing.Optional[typing.Sequence[Parameter]]

        mapping : typing.Optional[typing.Dict[str, typing.Optional[Computation]]]

        config : typing.Optional[OptimizeConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizeNetlistResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, Netlist, StatementDictionary

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.optimize(
            netlist=Netlist(),
            statements=StatementDictionary(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/optimize",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=typing.Sequence[Parameter], direction="write"
                ),
                "mapping": convert_and_respect_annotation_metadata(
                    object_=mapping, annotation=typing.Dict[str, typing.Optional[Computation]], direction="write"
                ),
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=OptimizeConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    OptimizeNetlistResponse,
                    parse_obj_as(
                        type_=OptimizeNetlistResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def placementoptimize(
        self,
        *,
        netlist: typing.Dict[str, typing.Optional[typing.Any]],
        method: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptimizePlacementBodyResponse:
        """
        Optimizes the placement of a circuit

        Parameters
        ----------
        netlist : typing.Dict[str, typing.Optional[typing.Any]]

        method : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizePlacementBodyResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.placementoptimize(
            netlist={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/optimize/placement",
            method="POST",
            json={
                "netlist": netlist,
                "method": method,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    OptimizePlacementBodyResponse,
                    parse_obj_as(
                        type_=OptimizePlacementBodyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def verify(
        self, *, code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyCircuitCodeResponse:
        """
        Verifies that the code for a circuit

        Parameters
        ----------
        code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyCircuitCodeResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.verify(
            code="code",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/verifycode",
            method="POST",
            json={
                "code": code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    VerifyCircuitCodeResponse,
                    parse_obj_as(
                        type_=VerifyCircuitCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_sax_spectrum(
        self,
        *,
        netlist: Netlist,
        wavelengths: typing.Sequence[float],
        port_pairs: typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[typing.Any]]]] = OMIT,
        settings: typing.Optional[Settings] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSpectrumResponse:
        """
        Get the spectrum of a circuit over various wavelengths and settings

        Parameters
        ----------
        netlist : Netlist

        wavelengths : typing.Sequence[float]

        port_pairs : typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[typing.Any]]]]

        settings : typing.Optional[Settings]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSpectrumResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, Netlist

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.get_sax_spectrum(
            netlist=Netlist(),
            wavelengths=[1.1],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/get_sax_spectrum",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "wavelengths": wavelengths,
                "port_pairs": port_pairs,
                "settings": convert_and_respect_annotation_metadata(
                    object_=settings, annotation=Settings, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetSpectrumResponse,
                    parse_obj_as(
                        type_=GetSpectrumResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_optimizable_parameters(
        self,
        *,
        netlist: Netlist,
        get_key_parameters: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOptimizableParametersResponse:
        """
        Gets the optimizable parameters of a circuit.

        Parameters
        ----------
        netlist : Netlist

        get_key_parameters : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOptimizableParametersResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, Netlist

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.get_optimizable_parameters(
            netlist=Netlist(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/optimizable-parameters",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "get_key_parameters": get_key_parameters,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetOptimizableParametersResponse,
                    parse_obj_as(
                        type_=GetOptimizableParametersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_code(
        self, *, code: str, netlist: Netlist, request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateCodeResponse:
        """
        Update GDS code to match the netlist

        Parameters
        ----------
        code : str

        netlist : Netlist

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateCodeResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, Netlist

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.pic.circuit.update_code(
            code="code",
            netlist=Netlist(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "pic/circuit/code/update",
            method="POST",
            json={
                "code": code,
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UpdateCodeResponse,
                    parse_obj_as(
                        type_=UpdateCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCircuitClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def parse(
        self,
        *,
        text: str,
        informalize: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParseStatementResponse:
        """
        Parse a piece of text into a valid formal statement, if possible.

        Parameters
        ----------
        text : str

        informalize : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParseStatementResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.parse(
                text="text",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/statement/parse",
            method="POST",
            json={
                "text": text,
                "informalize": informalize,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ParseStatementResponse,
                    parse_obj_as(
                        type_=ParseStatementResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def informalize(
        self, *, statement: Statement, request_options: typing.Optional[RequestOptions] = None
    ) -> InformalizeStatementResponse:
        """
        Informalize a formal statement about a circuit into a natural language text.

        Parameters
        ----------
        statement : Statement

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InformalizeStatementResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, ParameterConstraint

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.informalize(
                statement=ParameterConstraint(
                    text="text",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/statement/informalize",
            method="POST",
            json={
                "statement": convert_and_respect_annotation_metadata(
                    object_=statement, annotation=Statement, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    InformalizeStatementResponse,
                    parse_obj_as(
                        type_=InformalizeStatementResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def validate(
        self,
        *,
        netlist: Netlist,
        statements: StatementDictionary,
        mapping: typing.Optional[typing.Dict[str, typing.Optional[Computation]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ValidateNetlistResponse:
        """
        Validates a set of statements against a netlist.

        Parameters
        ----------
        netlist : Netlist

        statements : StatementDictionary

        mapping : typing.Optional[typing.Dict[str, typing.Optional[Computation]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidateNetlistResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, Netlist, StatementDictionary

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.validate(
                netlist=Netlist(),
                statements=StatementDictionary(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/validate",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
                "mapping": convert_and_respect_annotation_metadata(
                    object_=mapping, annotation=typing.Dict[str, typing.Optional[Computation]], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ValidateNetlistResponse,
                    parse_obj_as(
                        type_=ValidateNetlistResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def formalize(
        self,
        *,
        query: str,
        pdk: typing.Optional[PdkType] = OMIT,
        statements: typing.Optional[StatementDictionary] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FormalizeCircuitResponse:
        """
        Formalize a query about a circuit into a dictionary of constraints. Extends previous statements if provided.

        Parameters
        ----------
        query : str

        pdk : typing.Optional[PdkType]

        statements : typing.Optional[StatementDictionary]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FormalizeCircuitResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.formalize(
                query="query",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/query/formalize",
            method="POST",
            json={
                "query": query,
                "pdk": pdk,
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FormalizeCircuitResponse,
                    parse_obj_as(
                        type_=FormalizeCircuitResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def mapping(
        self,
        *,
        statements: StatementDictionary,
        netlist: Netlist,
        max_iter: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindMappingResponse:
        """
        Map variables in the constraints to computations on the netlist.

        Parameters
        ----------
        statements : StatementDictionary

        netlist : Netlist

        max_iter : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindMappingResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, Netlist, StatementDictionary

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.mapping(
                statements=StatementDictionary(),
                netlist=Netlist(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/mapping/find",
            method="POST",
            params={
                "max_iter": max_iter,
            },
            json={
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    FindMappingResponse,
                    parse_obj_as(
                        type_=FindMappingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def generate(
        self,
        *,
        query: str,
        max_iterations: typing.Optional[int] = OMIT,
        llm_model: typing.Optional[str] = OMIT,
        apply_orientation: typing.Optional[bool] = OMIT,
        apply_placement: typing.Optional[bool] = OMIT,
        apply_routing: typing.Optional[bool] = OMIT,
        return_cell: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateCodeResponse:
        """
        Generate GDS factory code to create a circuit

        Parameters
        ----------
        query : str

        max_iterations : typing.Optional[int]

        llm_model : typing.Optional[str]

        apply_orientation : typing.Optional[bool]

        apply_placement : typing.Optional[bool]

        apply_routing : typing.Optional[bool]

        return_cell : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateCodeResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.generate(
                query="query",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/generate",
            method="POST",
            json={
                "query": query,
                "max_iterations": max_iterations,
                "llm_model": llm_model,
                "apply_orientation": apply_orientation,
                "apply_placement": apply_placement,
                "apply_routing": apply_routing,
                "return_cell": return_cell,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GenerateCodeResponse,
                    parse_obj_as(
                        type_=GenerateCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def refine(
        self,
        *,
        query: str,
        max_iterations: typing.Optional[int] = OMIT,
        feedback: typing.Optional[str] = OMIT,
        code: typing.Optional[str] = OMIT,
        llm_model: typing.Optional[str] = OMIT,
        apply_orientation: typing.Optional[bool] = OMIT,
        apply_placement: typing.Optional[bool] = OMIT,
        apply_routing: typing.Optional[bool] = OMIT,
        return_cell: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RefineCodeResponse:
        """
        Refine GDS factory code to create a circuit

        Parameters
        ----------
        query : str

        max_iterations : typing.Optional[int]

        feedback : typing.Optional[str]

        code : typing.Optional[str]

        llm_model : typing.Optional[str]

        apply_orientation : typing.Optional[bool]

        apply_placement : typing.Optional[bool]

        apply_routing : typing.Optional[bool]

        return_cell : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RefineCodeResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.refine(
                query="query",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/refine",
            method="POST",
            json={
                "query": query,
                "max_iterations": max_iterations,
                "feedback": feedback,
                "code": code,
                "llm_model": llm_model,
                "apply_orientation": apply_orientation,
                "apply_placement": apply_placement,
                "apply_routing": apply_routing,
                "return_cell": return_cell,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RefineCodeResponse,
                    parse_obj_as(
                        type_=RefineCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def optimize(
        self,
        *,
        netlist: Netlist,
        statements: StatementDictionary,
        parameters: typing.Optional[typing.Sequence[Parameter]] = OMIT,
        mapping: typing.Optional[typing.Dict[str, typing.Optional[Computation]]] = OMIT,
        config: typing.Optional[OptimizeConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptimizeNetlistResponse:
        """
        Optimize a PIC circuit with given cost and constraints

        Parameters
        ----------
        netlist : Netlist

        statements : StatementDictionary

        parameters : typing.Optional[typing.Sequence[Parameter]]

        mapping : typing.Optional[typing.Dict[str, typing.Optional[Computation]]]

        config : typing.Optional[OptimizeConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizeNetlistResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, Netlist, StatementDictionary

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.optimize(
                netlist=Netlist(),
                statements=StatementDictionary(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/optimize",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "statements": convert_and_respect_annotation_metadata(
                    object_=statements, annotation=StatementDictionary, direction="write"
                ),
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=typing.Sequence[Parameter], direction="write"
                ),
                "mapping": convert_and_respect_annotation_metadata(
                    object_=mapping, annotation=typing.Dict[str, typing.Optional[Computation]], direction="write"
                ),
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=OptimizeConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    OptimizeNetlistResponse,
                    parse_obj_as(
                        type_=OptimizeNetlistResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def placementoptimize(
        self,
        *,
        netlist: typing.Dict[str, typing.Optional[typing.Any]],
        method: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptimizePlacementBodyResponse:
        """
        Optimizes the placement of a circuit

        Parameters
        ----------
        netlist : typing.Dict[str, typing.Optional[typing.Any]]

        method : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizePlacementBodyResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.placementoptimize(
                netlist={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/optimize/placement",
            method="POST",
            json={
                "netlist": netlist,
                "method": method,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    OptimizePlacementBodyResponse,
                    parse_obj_as(
                        type_=OptimizePlacementBodyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def verify(
        self, *, code: str, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyCircuitCodeResponse:
        """
        Verifies that the code for a circuit

        Parameters
        ----------
        code : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyCircuitCodeResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.verify(
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/verifycode",
            method="POST",
            json={
                "code": code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    VerifyCircuitCodeResponse,
                    parse_obj_as(
                        type_=VerifyCircuitCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_sax_spectrum(
        self,
        *,
        netlist: Netlist,
        wavelengths: typing.Sequence[float],
        port_pairs: typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[typing.Any]]]] = OMIT,
        settings: typing.Optional[Settings] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSpectrumResponse:
        """
        Get the spectrum of a circuit over various wavelengths and settings

        Parameters
        ----------
        netlist : Netlist

        wavelengths : typing.Sequence[float]

        port_pairs : typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[typing.Any]]]]

        settings : typing.Optional[Settings]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSpectrumResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, Netlist

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.get_sax_spectrum(
                netlist=Netlist(),
                wavelengths=[1.1],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/get_sax_spectrum",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "wavelengths": wavelengths,
                "port_pairs": port_pairs,
                "settings": convert_and_respect_annotation_metadata(
                    object_=settings, annotation=Settings, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetSpectrumResponse,
                    parse_obj_as(
                        type_=GetSpectrumResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_optimizable_parameters(
        self,
        *,
        netlist: Netlist,
        get_key_parameters: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOptimizableParametersResponse:
        """
        Gets the optimizable parameters of a circuit.

        Parameters
        ----------
        netlist : Netlist

        get_key_parameters : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOptimizableParametersResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, Netlist

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.get_optimizable_parameters(
                netlist=Netlist(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/optimizable-parameters",
            method="POST",
            json={
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
                "get_key_parameters": get_key_parameters,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetOptimizableParametersResponse,
                    parse_obj_as(
                        type_=GetOptimizableParametersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_code(
        self, *, code: str, netlist: Netlist, request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateCodeResponse:
        """
        Update GDS code to match the netlist

        Parameters
        ----------
        code : str

        netlist : Netlist

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateCodeResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, Netlist

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pic.circuit.update_code(
                code="code",
                netlist=Netlist(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pic/circuit/code/update",
            method="POST",
            json={
                "code": code,
                "netlist": convert_and_respect_annotation_metadata(
                    object_=netlist, annotation=Netlist, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UpdateCodeResponse,
                    parse_obj_as(
                        type_=UpdateCodeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
