# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...types.formalize_response import FormalizeResponse
from ...core.request_options import RequestOptions
from ...types.verify_response import VerifyResponse
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.pydantic_utilities import parse_obj_as
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConstraintsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def verify(
        self, *, constraints: FormalizeResponse, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyResponse:
        """
        Verifies that a set of constraints are consistent

        Parameters
        ----------
        constraints : FormalizeResponse

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyResponse
            Successful Response

        Examples
        --------
        from axiomatic import Axiomatic, FormalizeResponse

        client = Axiomatic(
            api_key="YOUR_API_KEY",
        )
        client.formalization.constraints.verify(
            constraints=FormalizeResponse(
                variables={"key": "value"},
                expressions=[],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "formalization/constraints/verify",
            method="POST",
            json={
                "constraints": convert_and_respect_annotation_metadata(
                    object_=constraints, annotation=FormalizeResponse, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    VerifyResponse,
                    parse_obj_as(
                        type_=VerifyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncConstraintsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def verify(
        self, *, constraints: FormalizeResponse, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyResponse:
        """
        Verifies that a set of constraints are consistent

        Parameters
        ----------
        constraints : FormalizeResponse

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyResponse
            Successful Response

        Examples
        --------
        import asyncio

        from axiomatic import AsyncAxiomatic, FormalizeResponse

        client = AsyncAxiomatic(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.formalization.constraints.verify(
                constraints=FormalizeResponse(
                    variables={"key": "value"},
                    expressions=[],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "formalization/constraints/verify",
            method="POST",
            json={
                "constraints": convert_and_respect_annotation_metadata(
                    object_=constraints, annotation=FormalizeResponse, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    VerifyResponse,
                    parse_obj_as(
                        type_=VerifyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
