# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rmfuse']

package_data = \
{'': ['*']}

install_requires = \
['bidict>=0.21.2,<0.22.0',
 'pyfuse3>=3.2.0,<4.0.0',
 'rmcl>=0.3.0,<0.4.0',
 'rmrl>=0.1.2,<0.2.0']

entry_points = \
{'console_scripts': ['rmfuse = rmfuse.fuse:main']}

setup_kwargs = {
    'name': 'rmfuse',
    'version': '0.1.0',
    'description': '',
    'long_description': '# RMfuse\n\nRMfuse provides access to your reMarkable Cloud files in the form of a\n[FUSE](https://github.com/libfuse/libfuse) filesystem.  These files are\nexposed either in their original format, or as PDF files that contain\nyour annotations.  This lets you manage files in the reMarkable Cloud\nusing the same tools you use on your local system.\n\n## Installation\n\nRMfuse requires Python 3.7 or later.  It also requires the FUSE3 library.\nThis should be available in most Linuxes (`libfuse3-3` in Debian-based\ndistributions) and BSDs.  RMfuse may work with\n[macFuse](https://osxfuse.github.io/), but that is untested.  Windows\nusers may try [WinFuse](https://github.com/billziss-gh/winfuse), also\nuntested.  Installation of RMfuse and its dependencies will likely\nrequire the FUSE3 headers and a C build system (`libfuse3-dev` and\n`build-essential` in Debian).\n\nRMfuse can be installed with pip:\n```\npip install rmfuse\n```\nAlternatively, you may clone this repository.\n[Poetry](https://python-poetry.org/) is used for development, so once that\nis installed you can run\n```\npoetry install\n```\n\n## Usage\n\nRMfuse installs the script `rmfuse`.  The script takes a single argument,\nthe path at which the filesystem should be mounted.  This must be an\nexisting directory.  Any files within that directory will be hidden as\nlong as RMfuse is mounted.\n```\nmkdir ~/remarkable\nrmfuse ~/remarkable\n```\n(If you installed with Poetry, you may need to run `poetry run rmfuse`.)\n\nThe first time RMfuse is run, it will need a _one-time code_ to get\naccess to your reMarkable Cloud account.  You will be prompted to get\nthat code from https://my.remarkable.com/connect/desktop, which may\nrequire logging in to your reMarkable account.  RMfuse uses that code\nto obtain tokens which it uses in the future to authenticate itself.\n\nTo unmount and halt RMfuse, use the `fusermount` command:\n```\nfusermount -u ~/remarkable\n```\n\n### Modes\n\nRMfuse offers several modes to display your reMarkable Cloud files.  You\ncan choose the mode with the `-m` option.\n\n`annot`: Displays all files in PDF format, with your annotations added.\nThis is the default mode.\n\n`orig`: Displays the original file for ebooks and PDF files.  Notebooks\nare rendered as PDF files, as in the `annot` mode.\n\n`raw`: Displays all files as ZIP files, reflecting the underlying format\nused by the reMarkable Cloud.  This may be useful when working with other\ntools that expect files in this form.\n\n`meta`: Displays metadata about the files in JSON format.  Only useful for\ndebugging.\n\nRMfuse provides a special file named `.mode` in root directory.  When read,\nthis file gives the current mode.  Writing a valid mode to this file will\nswitch the mode RMfuse is in.  Additionally, writing `refresh` to this file\nwill cause RMfuse to refresh its information from the reMarkable Cloud.\n(By default, this happens every five minutes.)\n```\n~/remarkable $ cat .mode\nannot\n~/remarkable $ ls\nbook.pdf        document.pdf    notebook.pdf\n~/remarkable $ echo orig > .mode\n~/remarkable $ ls\nbook.epub       document.pdf    notebook.pdf\n```\n\n### Capabilities\n\nRMfuse allows reading of all files in the reMarkable Cloud.  Since reading\nthe file requires several HTTP requests, as well as local processing, reads\nmake take some time.  Running RMfuse in verbose mode (`-v` or `-vv`) will\ndisplay information about the actions underway.  The most recent file\naccessed is cached, to improve performance.  More sophisticated caching\nis planned for the future.\n\nRMfuse does its best to provide accurate metadata for the files.  However,\nthe reMarkable Cloud provides only modification dates, so that is reported\nfor creation and access dates as well.  File sizes in `annot` mode are\nonly estimates until the file is read for the first time.  This metadata\nis cached locally to improve responsiveness in the future.\n\nFiles can be renamed and moved within the RMfuse filesystem.  These changes\nwill be propagated to the reMarkable Cloud.  Changes to the file extension\nwill be ignored.\n\nDeleting files from a RMfuse filesystem moves them into the reMarkable\nCloud\'s trash area.  These files are accessible in the `.trash` hidden\ndirectory in the root of the file system.  Deleting files within the\n`.trash` folder removes them from the reMarkable Cloud.  (_N.B._ It is\nnot known if this deletes the files from the cloud, or just hides them\nfrom clients.)\n\nEPUB and PDF files may be copied into the filesystem, and new directories\ncan be created.  These changes are uploaded to the reMarkable Cloud.\nCopying other types of files into the RMfuse filesystem will fail silently\n(unfortunately).  File extensions are ignored by RMfuse, and thus may\nchange when files are uploaded.  For instance, if `book.epub` is uploaded\nand RMFuse is in `annot` mode, it will show up in the filesystem as\n`book.pdf`.\n\nExisting files cannot be edited; they appear in read-only mode. If you\nwant to edit the contents of a file, you will need to copy it to your\nlocal filesystem, edit it, and then copy it back to the RMfuse filesystem.\nThis will cause annotations to be lost (in `orig` mode) or flattened into\nthe document itself (in `annot` mode).\n\n## Known Limitations\n\n- The file size for annotated files is just an estimate before the file\nis first read.  This can confuse some tools which use the file size to\ndetermine how much to read.  After reading the file once, the file size\nwill be correctly reported going forward; rerunning these tools a second\ntime is usually enough to get them working.\n\n- RMfuse sometimes fails to authenticate with the reMarkable Cloud\nservers when starting up.  Several failures are possible before success\nis achieved.  It is currently unknown what triggers this problem.  RMfuse\ndoes not handle this gracefully at present.\n\n- Adding a file other than an EPUB or PDF silently fails.  RMfuse does\nthrow an error when it has been given an invalid file, but this comes\ntoo late for FUSE to pass the error back to the caller.  RMfuse may be\nable to throw an error earlier, based on the first bytes it receives;\nthis will be investigated in the future.\n\n- RMfuse caches the most-recently accessed file in memory.  This is bad\nfor large files (too much memory used) and small files (we could cache\nseveral files).  A more sophisticated caching system is planned.\n\n## Libraries\n\nRMfuse is powered by [rmcl](https://github.com/rschroll/rmcl), for accessing\nthe reMarkable Cloud, and by [rmrl](https://github.com/rschroll/rmrl), for\nrendering annoated documents.  The early development of RMfuse can be found\nin the [rmcl repository](https://github.com/rschroll/rmcl)\n\n## Trademarks\n\nreMarkable(R) is a registered trademark of reMarkable AS. rmrl is not\naffiliated with, or endorsed by, reMarkable AS. The use of "reMarkable"\nin this work refers to the company’s e-paper tablet product(s).\n\n## Copyright\n\nCopyright 2020-2021 Robert Schroll\n\nRMfuse is released under the MIT license.  See LICENSE.txt for details.\n\n## Disclaimer of Warranty\n\nRMfuse is provided without any warranty.  Users accept the risk of damages,\nincluding the loss of data on their local system, on their reMarkable\ndevice, and in the reMarkable Cloud.\n\nIf it breaks, you get to keep both halves.\n',
    'author': 'Robert Schroll',
    'author_email': 'rschroll@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rschroll/rmfuse',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
