from __future__ import annotations
from typing import Protocol, runtime_checkable
from allytools.units import  Length

@runtime_checkable
class IGridMeta(Protocol):

    @property
    def min_x(self) -> Length: ...
    @property
    def min_y(self) -> Length: ...
    @property
    def dx(self) -> Length: ...
    @property
    def dy(self) -> Length: ...

    @property
    def description(self) -> str: ...
    @property
    def x_label(self) -> str: ...
    @property
    def y_label(self) -> str: ...
    @property
    def value_label(self) -> str: ...

