<!-- 
	This page is formatted for GitHub's markdown renderer 
	Note that GitHub does not allow for inline style or <script> tags.

	It is also displayed on PyPI, which has slightly different formatting
	e.g. can't use html <center> tags.
-->
<a href="https://badge.fury.io/py/aiqc"><img src="https://badge.fury.io/py/aiqc.svg" alt="PyPI version" height="18"></a>
<a href="https://aiqc.readthedocs.io"> <img src="https://readthedocs.org/projects/aiqc/badge/?version=latest" alt="docs status" height="18"></a>
[![License](https://img.shields.io/badge/License-BSD_3--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)

</br>
<h1 align='center'>📚&nbsp;&nbsp;<a href="https://aiqc.readthedocs.io/">Documentation</a></h1>
</br></br>


<a href="https://aiqc.readthedocs.io/">
	<img src="https://raw.githubusercontent.com/aiqc/aiqc/main/docs/images/web/framework_may4.png" width="95%" alt="framework"/>
</a>
</br></br></br>


<a href="https://aiqc.readthedocs.io/">
	<img src="https://raw.githubusercontent.com/aiqc/AIQC/main/docs/images/dashboard/experiment_tracker.gif" width="95%" alt="experiment_tracker"/>
</a>
</br></br></br>


<a href="https://aiqc.readthedocs.io/">
	<img src="https://raw.githubusercontent.com/aiqc/AIQC/main/docs/images/dashboard/compare_models.gif" width="95%" alt="compare_models"/>
</a>
</br></br></br>


# Install

```python
# Designed for Python 3.7.12 to mirror Google Colab
pip install --upgrade pip
pip install --upgrade wheel
pip install --upgrade aiqc

from aiqc import setup, lab, mlops

# Create & connect to SQLite db
setup()

# Launch dashboard to monitor training
lab.Tracker().start()

# Declare preprocessing steps
mlops.Pipeline.Tabular(...)

# Define, train, & evaluate models
mlops.Experiment(...).run_jobs()
```

> Official Installation Documentation:
>
> https://aiqc.readthedocs.io/en/latest/notebooks/installation.html


</br></br>
<h1 align='center'>📚&nbsp;&nbsp;<a href="https://aiqc.readthedocs.io/">Documentation</a></h1>
