# dqdata

Data sdk for Ducheng Quant Database.

## 1、安装：

```
pip install dqdata

或指定版本

pip install dqdata==0.2.5
```

```buildoutcfg
依赖包：numpy, pandas, urllib3
```

## 2、ApiClient

#### (1)、实例创建

```buildoutcfg
ApiClient(token='', host='api.shducheng.net', port=80, log_level=logging.INFO, api_urls=None)

token: token字符串
host: 接口服务地址，默认：api.shducheng.net
port: 接口服务端口，默认：80
log_level: 日志级别，默认：logging.INFO
api_urls: 接口地址服务路径
```

##### 示例：

```
api = ApiClient(token='xxxx-xxxx-xxxx')
```

#### (2)、查询指标信息

##### 方法说明：

```buildoutcfg
get_idx_dict(idx)

idx: 指标id
```

##### 示例：通过id查询指标信息

```
info = api.get_idx_dict(109646)
print(info)
```

##### 执行结果

```
{'id': 109646, 'code': 'RB_DC', 'name': '河钢承钢：天津市场价格：螺纹钢：HRB400E：Ф18-25mm（日）', 'unit': '元/吨', 'frequency': '日', 'description': None, 'tableName': 'T_STEEL', 'sourceType': 'mysteel', 'sourceCode': 'ST_0001246521', 'sourceDescription': None, 'industry': '黑色', 'type': '现货价格', 'commodity': 'RB', 'sjbId': None, 'userId': None, 'rowsCount': 1191, 'dateFirst': '2016-07-21T00:00:00', 'dateLast': '2021-04-28T00:00:00', 'timeLastUpdate': '2021-04-28T19:56:44.783', 'timeLastRequest': None, 'priority': None, 'status': None, 'shortName': None, 'updateDescription': None, 'indexPropertiesList': None, 'categoryId': None, 'indexName': None}
```

#### (3)、通过类型查询指标列表

##### 方法说明：

```buildoutcfg
get_dict_list(source_type):

source_type: 指标来源类型
```

##### 示例：通过类型查询指标列表

```
df = api.get_dict_list('wind')
print(df)
```

##### 执行结果

```
          id    code       name  ... categoryIdList commodityName sorting
0     102786  EXC_JY      美元中间价  ...           None          None    None
1     102804  PTA_JY  FOB鹿特丹 MX  ...           None          None    None
2     102805  PTA_JY    国产MX：华东  ...           None          None    None
3     102818  PTA_JY  国产PX：镇海炼化  ...           None          None    None
4     102835   PF_JY  TA01M.CZC  ...           None          None    None
...      ...     ...        ...  ...            ...           ...     ...
```

#### (4)、查询指标数据

##### 方法说明：

```buildoutcfg
get_series(ids, start_dt='2015-01-01', end_dt=None, column='id')

ids: 指标id或id列表
start_dt: 开始日期，默认：2015年1月1日
end_dt: 截至日期，默认：当日日期
column: 列名字段：id/name
```

##### 示例：通过id列表查询指标数据

```
df = api.get_series([109645, 109646], start_dt='2021-05-15')
print(df)
```

##### 执行结果

```
            109645  109646
date                      
2021-05-17  5910.0  5920.0
2021-05-18  5880.0  5910.0
2021-05-19  5610.0  5640.0
2021-05-20  5500.0  5530.0
2021-05-21  5450.0  5500.0
2021-05-24  5260.0  5310.0
2021-05-25  5210.0  5260.0
2021-05-26  5080.0  5130.0
2021-05-27  4980.0  5030.0
2021-05-28  5070.0  5120.0
```

##### 示例：使用指标名称作为列名

```
df = api.get_series([109645, 109646], column='name', start_dt='2021-05-15')
print(df)
```

##### 执行结果

```
            鑫达：天津市场价格：螺纹钢：HRB400E：Ф18-25mm（日）  河钢承钢：天津市场价格：螺纹钢：HRB400E：Ф18-25mm（日）
date                                                                              
2021-05-17                             5910.0                               5920.0
2021-05-18                             5880.0                               5910.0
2021-05-19                             5610.0                               5640.0
2021-05-20                             5500.0                               5530.0
2021-05-21                             5450.0                               5500.0
2021-05-24                             5260.0                               5310.0
2021-05-25                             5210.0                               5260.0
2021-05-26                             5080.0                               5130.0
2021-05-27                             4980.0                               5030.0
2021-05-28                             5070.0                               5120.0
```

#### (5)、插入指标数据

##### 方法说明：

```buildoutcfg
save_series(self, items, overwrite=False):

items: 指标数据列表，格式：[{'idx': 100001, 'date': datetime.datetime.today(), 'value': 100.05 }]
overwrite: 是否覆盖已有相同日期值，默认False
```

##### 示例：插入数据

```
items = []

for i in range(11):
    items.append({'idx': 114278, 'date': dt.datetime.today() - dt.timedelta(days=i + 10), 'value': i * 100})
    items.append({'idx': 109646, 'date': dt.datetime.today() - dt.timedelta(days=i + 10), 'value': i * 1000})

api.save_series(items, overwrite=False)
```

##### 执行结果

```
2021-06-01 17:12:05,983 - api_client.py[line:116]- INFO: T_STEEL 更新或新增了22条记录
```

##### 查询数据

```
df = api.get_series([109645, 109646], column='id', start_dt='2021-05-15')
print(df)
```

##### 执行结果

```
            109645  109646
date                      
2021-05-15   700.0  7000.0
2021-05-16   600.0  6000.0
2021-05-17   500.0  5000.0
2021-05-18   400.0  4000.0
2021-05-19   300.0  3000.0
2021-05-20   200.0  2000.0
2021-05-21   100.0  1000.0
2021-05-22     0.0     0.0
```

#### (6)、删除指标数据

##### 方法说明：

```buildoutcfg
del_series(ids, start_dt='1900-01-01', end_dt='2999-01-01')

ids: 指标id或id列表
start_dt: 开始日期，默认：1900-01-01
end_dt: 截至日期，默认：2999-01-01
```

##### 示例：清空数据

```
api.del_series([109645, 109646])
```

##### 执行结果

```
2021-06-01 14:55:42,583 - api_client.py[line:131]- INFO: 删除了728条数据。
2021-06-01 14:55:42,810 - api_client.py[line:131]- INFO: 删除了1191条数据。
```

##### 示例：删除指定起始日期数据

```
api.del_series([109645, 109646], start_dt='2021-04-15')
```

##### 执行结果

```
2021-06-01 14:59:28,538 - api_client.py[line:131]- INFO: 删除了15条数据。
2021-06-01 14:59:28,585 - api_client.py[line:131]- INFO: 删除了15条数据。
```

#### (7)、消息工具

##### 方法说明(短信)：

```buildoutcfg
send_sms(number, text, name='')

number: 手机号码
text: 消息文本
name: 通知名称
```

##### 示例：发送短消息

```
api.send_sms('139********', 'TableXXX数据更新完成', name='数据表更新')
```

##### 方法说明(微信)：

```buildoutcfg
send_wx(email, text)

email: 邮箱账号
text: 消息文本
```

##### 示例：发送微信消息

```
api.send_wx('zhangx@shxxxx.com.cn', 'TableXXX 数据更新完成')
```

## 2、 Wind API工具类

#### (1)、工具类引入

```buildoutcfg
from dqdata import WindUtil
```

#### (2)、获取交易日

##### 方法说明：

```buildoutcfg
tdays(start_date, end_date=None)

start_dt: 开始日期，格式：'2015-01-01'
end_dt: 截至日期，默认：当前日期
```

##### 示例：指定起止时间查询交易日列表

```
l = WindUtil.tdays('2020-03-15', end_date='2020-03-30')
print(l)
```

##### 执行结果

```
[datetime.datetime(2022, 3, 15, 0, 0), datetime.datetime(2022, 3, 16, 0, 0), datetime.datetime(2022, 3, 17, 0, 0), datetime.datetime(2022, 3, 18, 0, 0), datetime.datetime(2022, 3, 21, 0, 0), datetime.datetime(2022, 3, 22, 0, 0), datetime.datetime(2022, 3, 23, 0, 0), datetime.datetime(2022, 3, 24, 0, 0), datetime.datetime(2022, 3, 25, 0, 0), datetime.datetime(2022, 3, 28, 0, 0), datetime.datetime(2022, 3, 29, 0, 0), datetime.datetime(2022, 3, 30, 0, 0)]
```

#### (3)、获取时间序列数据(多品种单指标或单品种多指标)

##### 方法说明：

```buildoutcfg
wsd(codes, fields, start_date=None, end_date=None, options=None)

codes: Wind代码
fields: 数据栏位
start_date: 开始日期，默认：当前日期
end_date: 截止日期，默认：当前日期
options: wsd选项
```

##### 示例：查询恒生电子日行情数据

```
df = WindUtil.wsd('600570.SH', 'open,close,high,low', start_date='2021-04-01', end_date='2021-04-05')
print(df)
```

##### 执行结果

```
         date   OPEN  CLOSE   HIGH    LOW
0  2021-04-01  83.70  84.60  84.77  83.47
1  2021-04-02  84.80  84.78  85.43  84.21
2  2021-04-06  84.80  86.00  86.22  83.80
3  2021-04-07  85.46  84.35  85.60  82.81
4  2021-04-08  83.96  84.20  85.23  83.31
5  2021-04-09  85.00  82.84  85.00  81.83
6  2021-04-12  81.88  81.78  83.20  80.14
7  2021-04-13  81.30  81.08  82.14  80.55
8  2021-04-14  81.10  82.20  82.59  80.41
9  2021-04-15  82.18  82.68  82.90  81.60
```

#### (4)、获取宏观经济指标数据

##### 方法说明：

```buildoutcfg
edb(codes, start_date=None, end_date=None, options=None)

codes: Wind代码
start_date: 开始日期，默认：当前日期
end_date: 截止日期，默认：当前日期
options: wsd选项
```

##### 示例：查询住宅房屋新开工面积数据

```
df = WindUtil.edb('S0049582', start_date='2020-01-01', end_date='2021-04-01', options='')
print(df)
```

##### 执行结果

```
          date        CLOSE
0   2020-02-29    7559.4648
1   2020-03-31   20799.4490
2   2020-04-30   35248.3115
3   2020-05-31   50887.6337
4   2020-06-30   71582.8599
5   2020-07-31   88089.0966
6   2020-08-31  102485.8912
7   2020-09-30  117193.0523
8   2020-10-31  132481.0900
9   2020-11-30  147343.6000
10  2020-12-31  164328.5300
11  2021-02-28   12735.8000
12  2021-03-31   27056.8100
13  2021-04-30   40334.5984
```

#### (5)、获取最新行情数据

##### 方法说明：

```buildoutcfg
wsq(codes, fields)

codes: Wind代码
fields: 数据栏位
```

##### 示例：查询CU2207.SHF,RB2208.SHF最新价和成交量

```
df = WindUtil.wsq('CU2207.SHF,RB2208.SHF', 'rt_latest,rt_last_vol')
print(df)
```

##### 执行结果

```
         code  RT_LATEST  RT_LAST_VOL
0  CU2207.SHF    61480.0          5.0
1  RB2208.SHF     4211.0          2.0
```

#### (6)、获取板块成分(通过Wind板块ID)

##### 方法说明：

```buildoutcfg
sectors(sectorid, date=None)

sectorid: Wind板块ID
date: 指定日期，默认：当前日期
```

##### 示例：查询指定日期国内商品交易品种

```
df = WindUtil.sectors('1000010084000000', date='2020-08-28')
print(df)
```

##### 执行结果

```
         date wind_code  sec_name
1  2020-08-28     A.DCE     DCE豆一
2  2020-08-28    AG.SHF    SHFE白银
3  2020-08-28    AL.SHF     SHFE铝
4  2020-08-28    AP.CZC    CZCE苹果
5  2020-08-28    AU.SHF    SHFE黄金
..         ...        ...      ...
56 2020-08-28    WH.CZC    CZCE强麦
57 2020-08-28    WR.SHF    SHFE线材
58 2020-08-28     Y.DCE     DCE豆油
59 2020-08-28    ZC.CZC   CZCE动力煤
60 2020-08-28    ZN.SHF     SHFE锌
```

#### (7)、获取指数成分(通过Wind代码)

##### 方法说明：

```buildoutcfg
sectors_by_code(wind_code, date=None)

wind_code: Wind代码
date: 指定日期，默认：当前日期
```

##### 示例：查询沪深300成分股

```
df = WindUtil.sectors_by_code('000300.SH')
print(df)
```

##### 执行结果

```
          date  wind_code sec_name
1   2022-07-04  000001.SZ     平安银行
2   2022-07-04  000002.SZ      万科A
3   2022-07-04  000063.SZ     中兴通讯
4   2022-07-04  000066.SZ     中国长城
5   2022-07-04  000069.SZ     华侨城A
..         ...        ...      ...
296 2022-07-04  688363.SH     华熙生物
297 2022-07-04  688396.SH      华润微
298 2022-07-04  688561.SH    奇安信-U
299 2022-07-04  688599.SH     天合光能
300 2022-07-04  688981.SH     中芯国际
```

#### (8)、获取指定品种期货合约

##### 方法说明：

```buildoutcfg
fu_contracts(wind_code, start_date=None, end_date=None)

wind_code: Wind品种代码
start_date: 开始日期，默认：当前日期
end_date: 截至日期，默认：当前日期
```

##### 示例：查询黄大豆1号期货合约

```
df = WindUtil.fu_contracts('A.DCE')
print(df)
```

##### 执行结果

```
      sec_name   code  wind_code delivery_month  change_limit  target_margin contract_issue_date last_trade_date last_delivery_month
1  黄大豆1号2207合约  A2207  A2207.DCE         202207           8.0           20.0          2021-07-15      2022-07-14          2022-07-19
2  黄大豆1号2209合约  A2209  A2209.DCE         202209           8.0           12.0          2021-09-15      2022-09-15          2022-09-20
3  黄大豆1号2211合约  A2211  A2211.DCE         202211           8.0           12.0          2021-11-15      2022-11-14          2022-11-17
4  黄大豆1号2301合约  A2301  A2301.DCE         202301           8.0           12.0          2022-01-18      2023-01-17          2023-01-20
5  黄大豆1号2303合约  A2303  A2303.DCE         202303           8.0           12.0          2022-03-15      2023-03-14          2023-03-17
6  黄大豆1号2305合约  A2305  A2305.DCE         202305           8.0           12.0          2022-05-19      2023-05-18          2023-05-23
```

#### (9)、获取期货主力合约代码

##### 方法说明：

```buildoutcfg
fu_hiscode(wind_code, trade_date=None)

wind_code: Wind品种代码
trade_date: 指定日期，默认：当前日期
```

##### 示例：查询黄大豆1号期货主力合约代码

```
s = WindUtil.fu_hiscode('A.DCE')
print(s)
```

##### 执行结果

```
A2209.DCE
```
