"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
class EnvironmentUtils {
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                'Expected format: aws://account/region');
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    /**
     * Build an environment object from an account and region
     */
    static make(account, region) {
        return { account, region, name: this.format(account, region) };
    }
    /**
     * Format an environment string from an account and region
     */
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
//# sourceMappingURL=data:application/json;base64,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