"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * If this is set in the context, the aws:asset:xxx metadata entries will not be
 * added to the template. This is used, for example, when we run integrationt
 * tests.
 */
exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = 'aws:cdk:enable-asset-metadata';
/**
 * Metadata added to the CloudFormation template entries that map local assets
 * to resources.
 */
exports.ASSET_RESOURCE_METADATA_PATH_KEY = 'aws:asset:path';
exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = 'aws:asset:property';
/**
 * Separator string that separates the prefix separator from the object key separator.
 *
 * Asset keys will look like:
 *
 *    /assets/MyConstruct12345678/||abcdef12345.zip
 *
 * This allows us to encode both the prefix and the full location in a single
 * CloudFormation Template Parameter.
 */
exports.ASSET_PREFIX_SEPARATOR = '||';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzZXRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXNzZXRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7Ozs7R0FJRztBQUNVLFFBQUEsdUNBQXVDLEdBQUcsK0JBQStCLENBQUM7QUFDdkY7OztHQUdHO0FBQ1UsUUFBQSxnQ0FBZ0MsR0FBRyxnQkFBZ0IsQ0FBQztBQUNwRCxRQUFBLG9DQUFvQyxHQUFHLG9CQUFvQixDQUFDO0FBQ3pFOzs7Ozs7Ozs7R0FTRztBQUNVLFFBQUEsc0JBQXNCLEdBQUcsSUFBSSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBJZiB0aGlzIGlzIHNldCBpbiB0aGUgY29udGV4dCwgdGhlIGF3czphc3NldDp4eHggbWV0YWRhdGEgZW50cmllcyB3aWxsIG5vdCBiZVxuICogYWRkZWQgdG8gdGhlIHRlbXBsYXRlLiBUaGlzIGlzIHVzZWQsIGZvciBleGFtcGxlLCB3aGVuIHdlIHJ1biBpbnRlZ3JhdGlvbnRcbiAqIHRlc3RzLlxuICovXG5leHBvcnQgY29uc3QgQVNTRVRfUkVTT1VSQ0VfTUVUQURBVEFfRU5BQkxFRF9DT05URVhUID0gJ2F3czpjZGs6ZW5hYmxlLWFzc2V0LW1ldGFkYXRhJztcbi8qKlxuICogTWV0YWRhdGEgYWRkZWQgdG8gdGhlIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIGVudHJpZXMgdGhhdCBtYXAgbG9jYWwgYXNzZXRzXG4gKiB0byByZXNvdXJjZXMuXG4gKi9cbmV4cG9ydCBjb25zdCBBU1NFVF9SRVNPVVJDRV9NRVRBREFUQV9QQVRIX0tFWSA9ICdhd3M6YXNzZXQ6cGF0aCc7XG5leHBvcnQgY29uc3QgQVNTRVRfUkVTT1VSQ0VfTUVUQURBVEFfUFJPUEVSVFlfS0VZID0gJ2F3czphc3NldDpwcm9wZXJ0eSc7XG4vKipcbiAqIFNlcGFyYXRvciBzdHJpbmcgdGhhdCBzZXBhcmF0ZXMgdGhlIHByZWZpeCBzZXBhcmF0b3IgZnJvbSB0aGUgb2JqZWN0IGtleSBzZXBhcmF0b3IuXG4gKlxuICogQXNzZXQga2V5cyB3aWxsIGxvb2sgbGlrZTpcbiAqXG4gKiAgICAvYXNzZXRzL015Q29uc3RydWN0MTIzNDU2NzgvfHxhYmNkZWYxMjM0NS56aXBcbiAqXG4gKiBUaGlzIGFsbG93cyB1cyB0byBlbmNvZGUgYm90aCB0aGUgcHJlZml4IGFuZCB0aGUgZnVsbCBsb2NhdGlvbiBpbiBhIHNpbmdsZVxuICogQ2xvdWRGb3JtYXRpb24gVGVtcGxhdGUgUGFyYW1ldGVyLlxuICovXG5leHBvcnQgY29uc3QgQVNTRVRfUFJFRklYX1NFUEFSQVRPUiA9ICd8fCc7XG4iXX0=