"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* istanbul ignore file */
// eslint-disable-next-line import/no-extraneous-dependencies
const AWS = require("aws-sdk");
const https = require("https");
async function defaultHttpRequest(options, responseBody) {
    return new Promise((resolve, reject) => {
        try {
            const request = https.request(options, resolve);
            request.on('error', reject);
            request.write(responseBody);
            request.end();
        }
        catch (e) {
            reject(e);
        }
    });
}
let sfn;
let lambda;
async function defaultStartExecution(req) {
    if (!sfn) {
        sfn = new AWS.StepFunctions();
    }
    return await sfn.startExecution(req).promise();
}
async function defaultInvokeFunction(req) {
    if (!lambda) {
        lambda = new AWS.Lambda();
    }
    return await lambda.invoke(req).promise();
}
exports.startExecution = defaultStartExecution;
exports.invokeFunction = defaultInvokeFunction;
exports.httpRequest = defaultHttpRequest;
//# sourceMappingURL=data:application/json;base64,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