"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const construct_compat_1 = require("../construct-compat");
const custom_resource_provider_1 = require("../custom-resource-provider");
/**
 * A custom resource provider for CFN utilities such as `CfnJson`.
 */
class CfnUtilsProvider extends construct_compat_1.Construct {
    static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, 'AWSCDKCfnUtilsProvider', {
            runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_12,
            codeDirectory: `${__dirname}/cfn-utils-provider`,
        });
    }
}
exports.CfnUtilsProvider = CfnUtilsProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXV0aWxzLXByb3ZpZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY2ZuLXV0aWxzLXByb3ZpZGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsMERBQWdEO0FBQ2hELDBFQUFvRztBQUNwRzs7R0FFRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsNEJBQVM7SUFDcEMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFnQjtRQUN0QyxPQUFPLGlEQUFzQixDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsd0JBQXdCLEVBQUU7WUFDdkUsT0FBTyxFQUFFLHdEQUE2QixDQUFDLFNBQVM7WUFDaEQsYUFBYSxFQUFFLEdBQUcsU0FBUyxxQkFBcUI7U0FDbkQsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBUEQsNENBT0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICcuLi9jb25zdHJ1Y3QtY29tcGF0JztcbmltcG9ydCB7IEN1c3RvbVJlc291cmNlUHJvdmlkZXIsIEN1c3RvbVJlc291cmNlUHJvdmlkZXJSdW50aW1lIH0gZnJvbSAnLi4vY3VzdG9tLXJlc291cmNlLXByb3ZpZGVyJztcbi8qKlxuICogQSBjdXN0b20gcmVzb3VyY2UgcHJvdmlkZXIgZm9yIENGTiB1dGlsaXRpZXMgc3VjaCBhcyBgQ2ZuSnNvbmAuXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5VdGlsc1Byb3ZpZGVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgICBwdWJsaWMgc3RhdGljIGdldE9yQ3JlYXRlKHNjb3BlOiBDb25zdHJ1Y3QpIHtcbiAgICAgICAgcmV0dXJuIEN1c3RvbVJlc291cmNlUHJvdmlkZXIuZ2V0T3JDcmVhdGUoc2NvcGUsICdBV1NDREtDZm5VdGlsc1Byb3ZpZGVyJywge1xuICAgICAgICAgICAgcnVudGltZTogQ3VzdG9tUmVzb3VyY2VQcm92aWRlclJ1bnRpbWUuTk9ERUpTXzEyLFxuICAgICAgICAgICAgY29kZURpcmVjdG9yeTogYCR7X19kaXJuYW1lfS9jZm4tdXRpbHMtcHJvdmlkZXJgLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=