"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_parameter_1 = require("../cfn-parameter");
const construct_compat_1 = require("../construct-compat");
class FileAssetParameters extends construct_compat_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        // add parameters for s3 bucket and s3 key. those will be set by
        // the toolkit or by CI/CD when the stack is deployed and will include
        // the name of the bucket and the S3 key where the code lives.
        this.bucketNameParameter = new cfn_parameter_1.CfnParameter(this, 'S3Bucket', {
            type: 'String',
            description: `S3 bucket for asset "${id}"`,
        });
        this.objectKeyParameter = new cfn_parameter_1.CfnParameter(this, 'S3VersionKey', {
            type: 'String',
            description: `S3 key for asset version "${id}"`,
        });
        this.artifactHashParameter = new cfn_parameter_1.CfnParameter(this, 'ArtifactHash', {
            description: `Artifact hash for asset "${id}"`,
            type: 'String',
        });
    }
}
exports.FileAssetParameters = FileAssetParameters;
//# sourceMappingURL=data:application/json;base64,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