"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const physical_name_generator_1 = require("./private/physical-name-generator");
const token_1 = require("./token");
/**
 * Includes special markers for automatic generation of physical names.
 */
class PhysicalName {
    constructor() { }
}
exports.PhysicalName = PhysicalName;
/**
 * Use this to automatically generate a physical name for an AWS resource only
 * if the resource is referenced across environments (account/region).
 * Otherwise, the name will be allocated during deployment by CloudFormation.
 *
 * If you are certain that a resource will be referenced across environments,
 * you may also specify an explicit physical name for it. This option is
 * mostly designed for reusable constructs which may or may not be referenced
 * acrossed environments.
 */
PhysicalName.GENERATE_IF_NEEDED = token_1.Token.asString(new physical_name_generator_1.GeneratedWhenNeededMarker());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGh5c2ljYWwtbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBoeXNpY2FsLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSwrRUFBOEU7QUFDOUUsbUNBQWdDO0FBQ2hDOztHQUVHO0FBQ0gsTUFBYSxZQUFZO0lBWXJCLGdCQUF3QixDQUFDOztBQVo3QixvQ0FhQztBQVpHOzs7Ozs7Ozs7R0FTRztBQUNvQiwrQkFBa0IsR0FBRyxhQUFLLENBQUMsUUFBUSxDQUFDLElBQUksbURBQXlCLEVBQUUsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgR2VuZXJhdGVkV2hlbk5lZWRlZE1hcmtlciB9IGZyb20gJy4vcHJpdmF0ZS9waHlzaWNhbC1uYW1lLWdlbmVyYXRvcic7XG5pbXBvcnQgeyBUb2tlbiB9IGZyb20gJy4vdG9rZW4nO1xuLyoqXG4gKiBJbmNsdWRlcyBzcGVjaWFsIG1hcmtlcnMgZm9yIGF1dG9tYXRpYyBnZW5lcmF0aW9uIG9mIHBoeXNpY2FsIG5hbWVzLlxuICovXG5leHBvcnQgY2xhc3MgUGh5c2ljYWxOYW1lIHtcbiAgICAvKipcbiAgICAgKiBVc2UgdGhpcyB0byBhdXRvbWF0aWNhbGx5IGdlbmVyYXRlIGEgcGh5c2ljYWwgbmFtZSBmb3IgYW4gQVdTIHJlc291cmNlIG9ubHlcbiAgICAgKiBpZiB0aGUgcmVzb3VyY2UgaXMgcmVmZXJlbmNlZCBhY3Jvc3MgZW52aXJvbm1lbnRzIChhY2NvdW50L3JlZ2lvbikuXG4gICAgICogT3RoZXJ3aXNlLCB0aGUgbmFtZSB3aWxsIGJlIGFsbG9jYXRlZCBkdXJpbmcgZGVwbG95bWVudCBieSBDbG91ZEZvcm1hdGlvbi5cbiAgICAgKlxuICAgICAqIElmIHlvdSBhcmUgY2VydGFpbiB0aGF0IGEgcmVzb3VyY2Ugd2lsbCBiZSByZWZlcmVuY2VkIGFjcm9zcyBlbnZpcm9ubWVudHMsXG4gICAgICogeW91IG1heSBhbHNvIHNwZWNpZnkgYW4gZXhwbGljaXQgcGh5c2ljYWwgbmFtZSBmb3IgaXQuIFRoaXMgb3B0aW9uIGlzXG4gICAgICogbW9zdGx5IGRlc2lnbmVkIGZvciByZXVzYWJsZSBjb25zdHJ1Y3RzIHdoaWNoIG1heSBvciBtYXkgbm90IGJlIHJlZmVyZW5jZWRcbiAgICAgKiBhY3Jvc3NlZCBlbnZpcm9ubWVudHMuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBHRU5FUkFURV9JRl9ORUVERUQgPSBUb2tlbi5hc1N0cmluZyhuZXcgR2VuZXJhdGVkV2hlbk5lZWRlZE1hcmtlcigpKTtcbiAgICBwcml2YXRlIGNvbnN0cnVjdG9yKCkgeyB9XG59XG4iXX0=