"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Determines how symlinks are followed.
 */
var SymlinkFollowMode;
(function (SymlinkFollowMode) {
    /**
     * Never follow symlinks.
     */
    SymlinkFollowMode["NEVER"] = "never";
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    SymlinkFollowMode["ALWAYS"] = "always";
    /**
     * Only follows symlinks that are external to the source directory.
     */
    SymlinkFollowMode["EXTERNAL"] = "external";
    /**
     * Forbids source from having any symlinks pointing outside of the source
     * tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     */
    SymlinkFollowMode["BLOCK_EXTERNAL"] = "internal-only";
})(SymlinkFollowMode = exports.SymlinkFollowMode || (exports.SymlinkFollowMode = {}));
//# sourceMappingURL=data:application/json;base64,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