"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const copy_1 = require("./copy");
const fingerprint_1 = require("./fingerprint");
__export(require("./options"));
/**
 * File system utilities.
 */
class FileSystem {
    /**
     * Copies an entire directory structure.
     * @param srcDir Source directory
     * @param destDir Destination directory
     * @param options options
     * @param rootDir Root directory to calculate exclusions from
     */
    static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
    }
    /**
     * Produces fingerprint based on the contents of a single file or an entire directory tree.
     *
     * The fingerprint will also include:
     * 1. An extra string if defined in `options.extra`.
     * 2. The set of exclude patterns, if defined in `options.exclude`
     * 3. The symlink follow mode value.
     *
     * @param fileOrDirectory The directory or file to fingerprint
     * @param options Fingerprinting options
     */
    static fingerprint(fileOrDirectory, options = {}) {
        return fingerprint_1.fingerprint(fileOrDirectory, options);
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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