"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
/**
 * Includes a CloudFormation template into a stack. All elements of the template will be merged into
 * the current stack, together with any elements created programmatically.
 */
class CfnInclude extends cfn_element_1.CfnElement {
    /**
     * Creates an adopted template construct. The template will be incorporated into the stack as-is with no changes at all.
     * This means that logical IDs of entities within this template may conflict with logical IDs of entities that are part of the
     * stack.
     * @param scope The parent construct of this template
     * @param id The ID of this construct
     * @param props Initialization properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.template = props.template;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return this.template;
    }
}
exports.CfnInclude = CfnInclude;
//# sourceMappingURL=data:application/json;base64,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