"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an AWS CloudFormation stack.
     */
    ArtifactType["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
    /**
     * Manifest for all assets in the Cloud Assembly
     */
    ArtifactType["ASSET_MANIFEST"] = "cdk:asset-manifest";
})(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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