"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
exports.InvokeActivity = InvokeActivity;
//# sourceMappingURL=data:application/json;base64,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