"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const sfn = require("../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const path = require("path");
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
class EvaluateExpression {
    constructor(props) {
        this.props = props;
    }
    bind(task) {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.Data.stringAt(m),
            }), {});
        }
        const evalFn = createEvalFn(this.props.runtime || lambda.Runtime.NODEJS_10_X, task);
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            resourceArn: evalFn.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: [evalFn.functionArn],
                    actions: ['lambda:InvokeFunction'],
                })],
            parameters,
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
function createEvalFn(runtime, scope) {
    const code = lambda.Code.asset(path.join(__dirname, `eval-${runtime.name}-handler`));
    const lambdaPurpose = 'Eval';
    switch (runtime) {
        case lambda.Runtime.NODEJS_10_X:
            return new lambda.SingletonFunction(scope, 'EvalFunction', {
                runtime,
                handler: 'index.handler',
                uuid: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
                lambdaPurpose,
                code,
            });
        // TODO: implement other runtimes
        default:
            throw new Error(`The runtime ${runtime.name} is currently not supported.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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