"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const resource_arn_suffix_1 = require("../resource-arn-suffix");
const emr_create_cluster_1 = require("./emr-create-cluster");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
class EmrModifyInstanceGroupByName {
    constructor(props) {
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.ServiceIntegrationPattern.FIRE_AND_FORGET),
            policyStatements: [
                new iam.PolicyStatement({
                    actions: [
                        'elasticmapreduce:ModifyInstanceGroups',
                        'elasticmapreduce:ListInstanceGroups',
                    ],
                    resources: [`arn:aws:elasticmapreduce:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:cluster/*`],
                }),
            ],
            parameters: {
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup),
            },
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
(function (EmrModifyInstanceGroupByName) {
    /**
     * Render the InstanceResizePolicyProperty to JSON
     *
     * @param property
     */
    function InstanceResizePolicyPropertyToJson(property) {
        var _a;
        return {
            InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
            InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
            InstanceTerminationTimeout: cdk.numberToCloudFormation((_a = property.instanceTerminationTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
        };
    }
    EmrModifyInstanceGroupByName.InstanceResizePolicyPropertyToJson = InstanceResizePolicyPropertyToJson;
    /**
     * Render the ShrinkPolicyProperty to JSON
     *
     * @param property
     */
    function ShrinkPolicyPropertyToJson(property) {
        var _a;
        return {
            DecommissionTimeout: cdk.numberToCloudFormation((_a = property.decommissionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
            InstanceResizePolicy: (property.instanceResizePolicy === undefined) ?
                property.instanceResizePolicy :
                InstanceResizePolicyPropertyToJson(property.instanceResizePolicy),
        };
    }
    EmrModifyInstanceGroupByName.ShrinkPolicyPropertyToJson = ShrinkPolicyPropertyToJson;
    /**
     * Render the InstanceGroupModifyConfigPropety to JSON
     *
     * @param property
     */
    function InstanceGroupModifyConfigPropertyToJson(property) {
        return {
            Configurations: cdk.listMapper(emr_create_cluster_1.EmrCreateCluster.ConfigurationPropertyToJson)(property.configurations),
            EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
            InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
            ShrinkPolicy: (property.shrinkPolicy === undefined) ?
                property.shrinkPolicy :
                ShrinkPolicyPropertyToJson(property.shrinkPolicy),
        };
    }
    EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
})(EmrModifyInstanceGroupByName = exports.EmrModifyInstanceGroupByName || (exports.EmrModifyInstanceGroupByName = {}));
//# sourceMappingURL=data:application/json;base64,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