import * as sfn from "../../../aws-stepfunctions";
import * as cdk from "../../../core";
import { EmrCreateCluster } from './emr-create-cluster';
/**
 * Properties for EmrModifyInstanceGroupByName
 *
 * @experimental
 */
export interface EmrModifyInstanceGroupByNameProps {
    /**
     * The ClusterId to update.
     */
    readonly clusterId: string;
    /**
     * The InstanceGroupName to update.
     */
    readonly instanceGroupName: string;
    /**
     * The JSON that you want to provide to your ModifyInstanceGroup call as input.
     *
     * This uses the same syntax as the ModifyInstanceGroups API.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ModifyInstanceGroups.html
     */
    readonly instanceGroup: EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty;
}
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrModifyInstanceGroupByName implements sfn.IStepFunctionsTask {
    private readonly props;
    constructor(props: EmrModifyInstanceGroupByNameProps);
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
}
export declare namespace EmrModifyInstanceGroupByName {
    /**
     * Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceResizePolicy.html
     *
     * @experimental
     */
    interface InstanceResizePolicyProperty {
        /**
         * Specific list of instances to be protected when shrinking an instance group.
         *
         * @default No instancesToProtect
         */
        readonly instancesToProtect?: string[];
        /**
         * Specific list of instances to be terminated when shrinking an instance group.
         *
         * @default No instancesToTerminate
         */
        readonly instancesToTerminate?: string[];
        /**
         * Decommissioning timeout override for the specific list of instances to be terminated.
         *
         * @default EMR selected default
         */
        readonly instanceTerminationTimeout?: cdk.Duration;
    }
    /**
     * Render the InstanceResizePolicyProperty to JSON
     *
     * @param property
     */
    function InstanceResizePolicyPropertyToJson(property: InstanceResizePolicyProperty): {
        InstancesToProtect: any;
        InstancesToTerminate: any;
        InstanceTerminationTimeout: any;
    };
    /**
     * Policy for customizing shrink operations. Allows configuration of decommissioning timeout and targeted instance shrinking.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html
     *
     * @experimental
     */
    interface ShrinkPolicyProperty {
        /**
         * The desired timeout for decommissioning an instance. Overrides the default YARN decommissioning timeout.
         *
         * @default EMR selected default
         */
        readonly decommissionTimeout?: cdk.Duration;
        /**
         * Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
         *
         * @default No instanceResizePolicy
         */
        readonly instanceResizePolicy?: InstanceResizePolicyProperty;
    }
    /**
     * Render the ShrinkPolicyProperty to JSON
     *
     * @param property
     */
    function ShrinkPolicyPropertyToJson(property: ShrinkPolicyProperty): {
        DecommissionTimeout: any;
        InstanceResizePolicy: {
            InstancesToProtect: any;
            InstancesToTerminate: any;
            InstanceTerminationTimeout: any;
        } | undefined;
    };
    /**
     * Modify the size or configurations of an instance group.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupModifyConfig.html
     *
     * @experimental
     */
    interface InstanceGroupModifyConfigProperty {
        /**
         * A list of new or modified configurations to apply for an instance group.
         *
         * @default No configurations
         */
        readonly configurations?: EmrCreateCluster.ConfigurationProperty[];
        /**
         * The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not return to its original requested size.
         *
         * @default No eC2InstanceIdsToTerminate
         */
        readonly eC2InstanceIdsToTerminate?: string[];
        /**
         * Target size for the instance group.
         *
         * @default No instanceCount
         */
        readonly instanceCount?: number;
        /**
         * Policy for customizing shrink operations.
         *
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html
         *
         * @default No shrinkPolicy
         */
        readonly shrinkPolicy?: ShrinkPolicyProperty;
    }
    /**
     * Render the InstanceGroupModifyConfigPropety to JSON
     *
     * @param property
     */
    function InstanceGroupModifyConfigPropertyToJson(property: InstanceGroupModifyConfigProperty): {
        Configurations: any;
        EC2InstanceIdsToTerminate: any;
        InstanceCount: any;
        ShrinkPolicy: {
            DecommissionTimeout: any;
            InstanceResizePolicy: {
                InstancesToProtect: any;
                InstancesToTerminate: any;
                InstanceTerminationTimeout: any;
            } | undefined;
        } | undefined;
    };
}
