"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const run_ecs_task_base_1 = require("./run-ecs-task-base");
/**
 * Start a service on an ECS cluster
 */
class RunEcsFargateTask extends run_ecs_task_base_1.EcsRunTaskBase {
    constructor(props) {
        if (!props.taskDefinition.isFargateCompatible) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with Fargate');
        }
        if (!props.taskDefinition.defaultContainer) {
            throw new Error('A TaskDefinition must have at least one essential container');
        }
        super({
            ...props,
            parameters: {
                LaunchType: 'FARGATE',
            },
        });
        this.configureAwsVpcNetworking(props.cluster.vpc, props.assignPublicIp, props.subnets, props.securityGroup);
    }
}
exports.RunEcsFargateTask = RunEcsFargateTask;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVuLWVjcy1mYXJnYXRlLXRhc2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJydW4tZWNzLWZhcmdhdGUtdGFzay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBLDJEQUE0RTtBQWlDNUU7O0dBRUc7QUFDSCxNQUFhLGlCQUFrQixTQUFRLGtDQUFjO0lBQ2pELFlBQVksS0FBNkI7UUFDckMsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsbUJBQW1CLEVBQUU7WUFDM0MsTUFBTSxJQUFJLEtBQUssQ0FBQywwRUFBMEUsQ0FBQyxDQUFDO1NBQy9GO1FBQ0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLEVBQUU7WUFDeEMsTUFBTSxJQUFJLEtBQUssQ0FBQyw2REFBNkQsQ0FBQyxDQUFDO1NBQ2xGO1FBQ0QsS0FBSyxDQUFDO1lBQ0YsR0FBRyxLQUFLO1lBQ1IsVUFBVSxFQUFFO2dCQUNSLFVBQVUsRUFBRSxTQUFTO2FBQ3hCO1NBQ0osQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLHlCQUF5QixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxjQUFjLEVBQUUsS0FBSyxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEgsQ0FBQztDQUNKO0FBaEJELDhDQWdCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tIFwiLi4vLi4vLi4vYXdzLWVjMlwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWVjMidcbmltcG9ydCAqIGFzIGVjcyBmcm9tIFwiLi4vLi4vLi4vYXdzLWVjc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWVjcydcbmltcG9ydCB7IENvbW1vbkVjc1J1blRhc2tQcm9wcywgRWNzUnVuVGFza0Jhc2UgfSBmcm9tICcuL3J1bi1lY3MtdGFzay1iYXNlJztcbi8qKlxuICogUHJvcGVydGllcyB0byBkZWZpbmUgYW4gRUNTIHNlcnZpY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSdW5FY3NGYXJnYXRlVGFza1Byb3BzIGV4dGVuZHMgQ29tbW9uRWNzUnVuVGFza1Byb3BzIHtcbiAgICAvKipcbiAgICAgKiBBc3NpZ24gcHVibGljIElQIGFkZHJlc3NlcyB0byBlYWNoIHRhc2tcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXNzaWduUHVibGljSXA/OiBib29sZWFuO1xuICAgIC8qKlxuICAgICAqIEluIHdoYXQgc3VibmV0cyB0byBwbGFjZSB0aGUgdGFzaydzIEVOSXNcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IFByaXZhdGUgc3VibmV0IGlmIGFzc2lnblB1YmxpY0lwLCBwdWJsaWMgc3VibmV0cyBvdGhlcndpc2VcbiAgICAgKi9cbiAgICByZWFkb25seSBzdWJuZXRzPzogZWMyLlN1Ym5ldFNlbGVjdGlvbjtcbiAgICAvKipcbiAgICAgKiBFeGlzdGluZyBzZWN1cml0eSBncm91cCB0byB1c2UgZm9yIHRoZSB0YXNrc1xuICAgICAqXG4gICAgICogQGRlZmF1bHQgQSBuZXcgc2VjdXJpdHkgZ3JvdXAgaXMgY3JlYXRlZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXA/OiBlYzIuSVNlY3VyaXR5R3JvdXA7XG4gICAgLyoqXG4gICAgICogRmFyZ2F0ZSBwbGF0Zm9ybSB2ZXJzaW9uIHRvIHJ1biB0aGlzIHNlcnZpY2Ugb25cbiAgICAgKlxuICAgICAqIFVubGVzcyB5b3UgaGF2ZSBzcGVjaWZpYyBjb21wYXRpYmlsaXR5IHJlcXVpcmVtZW50cywgeW91IGRvbid0IG5lZWQgdG9cbiAgICAgKiBzcGVjaWZ5IHRoaXMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBMYXRlc3RcbiAgICAgKi9cbiAgICByZWFkb25seSBwbGF0Zm9ybVZlcnNpb24/OiBlY3MuRmFyZ2F0ZVBsYXRmb3JtVmVyc2lvbjtcbn1cbi8qKlxuICogU3RhcnQgYSBzZXJ2aWNlIG9uIGFuIEVDUyBjbHVzdGVyXG4gKi9cbmV4cG9ydCBjbGFzcyBSdW5FY3NGYXJnYXRlVGFzayBleHRlbmRzIEVjc1J1blRhc2tCYXNlIHtcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogUnVuRWNzRmFyZ2F0ZVRhc2tQcm9wcykge1xuICAgICAgICBpZiAoIXByb3BzLnRhc2tEZWZpbml0aW9uLmlzRmFyZ2F0ZUNvbXBhdGlibGUpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignU3VwcGxpZWQgVGFza0RlZmluaXRpb24gaXMgbm90IGNvbmZpZ3VyZWQgZm9yIGNvbXBhdGliaWxpdHkgd2l0aCBGYXJnYXRlJyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCFwcm9wcy50YXNrRGVmaW5pdGlvbi5kZWZhdWx0Q29udGFpbmVyKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0EgVGFza0RlZmluaXRpb24gbXVzdCBoYXZlIGF0IGxlYXN0IG9uZSBlc3NlbnRpYWwgY29udGFpbmVyJyk7XG4gICAgICAgIH1cbiAgICAgICAgc3VwZXIoe1xuICAgICAgICAgICAgLi4ucHJvcHMsXG4gICAgICAgICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgICAgICAgICAgTGF1bmNoVHlwZTogJ0ZBUkdBVEUnLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgfSk7XG4gICAgICAgIHRoaXMuY29uZmlndXJlQXdzVnBjTmV0d29ya2luZyhwcm9wcy5jbHVzdGVyLnZwYywgcHJvcHMuYXNzaWduUHVibGljSXAsIHByb3BzLnN1Ym5ldHMsIHByb3BzLnNlY3VyaXR5R3JvdXApO1xuICAgIH1cbn1cbiJdfQ==