"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const sns_generated_1 = require("./sns.generated");
/**
 * Applies a policy to SNS topics.
 */
class TopicPolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true,
        });
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn),
        });
    }
}
exports.TopicPolicy = TopicPolicy;
//# sourceMappingURL=data:application/json;base64,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