"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The type of email encoding to use for a SNS action.
 */
var EmailEncoding;
(function (EmailEncoding) {
    /**
     * Base 64
     */
    EmailEncoding["BASE64"] = "Base64";
    /**
     * UTF-8
     */
    EmailEncoding["UTF8"] = "UTF-8";
})(EmailEncoding = exports.EmailEncoding || (exports.EmailEncoding = {}));
/**
 * Publishes the email content within a notification to Amazon SNS.
 */
class Sns {
    constructor(props) {
        this.props = props;
    }
    bind(_rule) {
        return {
            snsAction: {
                encoding: this.props.encoding,
                topicArn: this.props.topic.topicArn,
            },
        };
    }
}
exports.Sns = Sns;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBRUE7O0dBRUc7QUFDSCxJQUFZLGFBU1g7QUFURCxXQUFZLGFBQWE7SUFDckI7O09BRUc7SUFDSCxrQ0FBaUIsQ0FBQTtJQUNqQjs7T0FFRztJQUNILCtCQUFjLENBQUE7QUFDbEIsQ0FBQyxFQVRXLGFBQWEsR0FBYixxQkFBYSxLQUFiLHFCQUFhLFFBU3hCO0FBZ0JEOztHQUVHO0FBQ0gsTUFBYSxHQUFHO0lBQ1osWUFBNkIsS0FBZTtRQUFmLFVBQUssR0FBTCxLQUFLLENBQVU7SUFDNUMsQ0FBQztJQUNNLElBQUksQ0FBQyxLQUF1QjtRQUMvQixPQUFPO1lBQ0gsU0FBUyxFQUFFO2dCQUNQLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7Z0JBQzdCLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxRQUFRO2FBQ3RDO1NBQ0osQ0FBQztJQUNOLENBQUM7Q0FDSjtBQVhELGtCQVdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VzIGZyb20gXCIuLi8uLi9hd3Mtc2VzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc2VzJ1xuaW1wb3J0ICogYXMgc25zIGZyb20gXCIuLi8uLi9hd3Mtc25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zJ1xuLyoqXG4gKiBUaGUgdHlwZSBvZiBlbWFpbCBlbmNvZGluZyB0byB1c2UgZm9yIGEgU05TIGFjdGlvbi5cbiAqL1xuZXhwb3J0IGVudW0gRW1haWxFbmNvZGluZyB7XG4gICAgLyoqXG4gICAgICogQmFzZSA2NFxuICAgICAqL1xuICAgIEJBU0U2NCA9ICdCYXNlNjQnLFxuICAgIC8qKlxuICAgICAqIFVURi04XG4gICAgICovXG4gICAgVVRGOCA9ICdVVEYtOCdcbn1cbi8qKlxuICogQ29uc3RydWN0aW9uIHByb3BlcnRpZXMgZm9yIGEgU05TIGFjdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTbnNQcm9wcyB7XG4gICAgLyoqXG4gICAgICogVGhlIGVuY29kaW5nIHRvIHVzZSBmb3IgdGhlIGVtYWlsIHdpdGhpbiB0aGUgQW1hem9uIFNOUyBub3RpZmljYXRpb24uXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBVVEYtOFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuY29kaW5nPzogRW1haWxFbmNvZGluZztcbiAgICAvKipcbiAgICAgKiBUaGUgU05TIHRvcGljIHRvIG5vdGlmeS5cbiAgICAgKi9cbiAgICByZWFkb25seSB0b3BpYzogc25zLklUb3BpYztcbn1cbi8qKlxuICogUHVibGlzaGVzIHRoZSBlbWFpbCBjb250ZW50IHdpdGhpbiBhIG5vdGlmaWNhdGlvbiB0byBBbWF6b24gU05TLlxuICovXG5leHBvcnQgY2xhc3MgU25zIGltcGxlbWVudHMgc2VzLklSZWNlaXB0UnVsZUFjdGlvbiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogU25zUHJvcHMpIHtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoX3J1bGU6IHNlcy5JUmVjZWlwdFJ1bGUpOiBzZXMuUmVjZWlwdFJ1bGVBY3Rpb25Db25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgc25zQWN0aW9uOiB7XG4gICAgICAgICAgICAgICAgZW5jb2Rpbmc6IHRoaXMucHJvcHMuZW5jb2RpbmcsXG4gICAgICAgICAgICAgICAgdG9waWNBcm46IHRoaXMucHJvcHMudG9waWMudG9waWNBcm4sXG4gICAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==