"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define an HTTP Namespace
 */
class HttpNamespace extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const ns = new servicediscovery_generated_1.CfnHttpNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.HTTP;
    }
    static fromHttpNamespaceAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.HTTP;
            }
        }
        return new Import(scope, id);
    }
    /** @attribute */
    get httpNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get httpNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get httpNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.HttpNamespace = HttpNamespace;
//# sourceMappingURL=data:application/json;base64,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