"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
exports.StorageClass = StorageClass;
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
//# sourceMappingURL=data:application/json;base64,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