"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const region_info_1 = require("../../region-info"); // Automatically re-written from '@aws-cdk/region-info'
/**
 * Use a S3 as an alias record target
 */
class BucketWebsiteTarget {
    constructor(bucket) {
        this.bucket = bucket;
    }
    bind(_record) {
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)',
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
//# sourceMappingURL=data:application/json;base64,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