import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::RDS::DBCluster`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
export interface CfnDBClusterProps {
    /**
     * `AWS::RDS::DBCluster.Engine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine
     */
    readonly engine: string;
    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles
     */
    readonly associatedRoles?: Array<CfnDBCluster.DBClusterRoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow
     */
    readonly backtrackWindow?: number;
    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backuprententionperiod
     */
    readonly backupRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBCluster.DatabaseName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename
     */
    readonly databaseName?: string;
    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier
     */
    readonly dbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname
     */
    readonly dbClusterParameterGroupName?: string;
    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBCluster.DeletionProtection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports
     */
    readonly enableCloudwatchLogsExports?: string[];
    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint
     */
    readonly enableHttpEndpoint?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication
     */
    readonly enableIamDatabaseAuthentication?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EngineMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode
     */
    readonly engineMode?: string;
    /**
     * `AWS::RDS::DBCluster.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::DBCluster.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::RDS::DBCluster.MasterUsername`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername
     */
    readonly masterUsername?: string;
    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword
     */
    readonly masterUserPassword?: string;
    /**
     * `AWS::RDS::DBCluster.Port`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port
     */
    readonly port?: number;
    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier
     */
    readonly replicationSourceIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.RestoreType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype
     */
    readonly restoreType?: string;
    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration
     */
    readonly scalingConfiguration?: CfnDBCluster.ScalingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier
     */
    readonly snapshotIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier
     */
    readonly sourceDbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.SourceRegion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion
     */
    readonly sourceRegion?: string;
    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime
     */
    readonly useLatestRestorableTime?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`
 *
 * @cloudformationResource AWS::RDS::DBCluster
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
export declare class CfnDBCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDBCluster;
    /**
     * @cloudformationAttribute Endpoint.Address
     */
    readonly attrEndpointAddress: string;
    /**
     * @cloudformationAttribute Endpoint.Port
     */
    readonly attrEndpointPort: string;
    /**
     * @cloudformationAttribute ReadEndpoint.Address
     */
    readonly attrReadEndpointAddress: string;
    /**
     * `AWS::RDS::DBCluster.Engine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine
     */
    engine: string;
    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles
     */
    associatedRoles: Array<CfnDBCluster.DBClusterRoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow
     */
    backtrackWindow: number | undefined;
    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backuprententionperiod
     */
    backupRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBCluster.DatabaseName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename
     */
    databaseName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier
     */
    dbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname
     */
    dbClusterParameterGroupName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DeletionProtection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports
     */
    enableCloudwatchLogsExports: string[] | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint
     */
    enableHttpEndpoint: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication
     */
    enableIamDatabaseAuthentication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EngineMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode
     */
    engineMode: string | undefined;
    /**
     * `AWS::RDS::DBCluster.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::DBCluster.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBCluster.MasterUsername`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername
     */
    masterUsername: string | undefined;
    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword
     */
    masterUserPassword: string | undefined;
    /**
     * `AWS::RDS::DBCluster.Port`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port
     */
    port: number | undefined;
    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier
     */
    replicationSourceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.RestoreType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype
     */
    restoreType: string | undefined;
    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration
     */
    scalingConfiguration: CfnDBCluster.ScalingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier
     */
    snapshotIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier
     */
    sourceDbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.SourceRegion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion
     */
    sourceRegion: string | undefined;
    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime
     */
    useLatestRestorableTime: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDBCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html
     */
    interface DBClusterRoleProperty {
        /**
         * `CfnDBCluster.DBClusterRoleProperty.FeatureName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html#cfn-rds-dbcluster-dbclusterrole-featurename
         */
        readonly featureName?: string;
        /**
         * `CfnDBCluster.DBClusterRoleProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html#cfn-rds-dbcluster-dbclusterrole-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnDBCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html
     */
    interface ScalingConfigurationProperty {
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.AutoPause`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-autopause
         */
        readonly autoPause?: boolean | cdk.IResolvable;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MaxCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-maxcapacity
         */
        readonly maxCapacity?: number;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MinCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-mincapacity
         */
        readonly minCapacity?: number;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.SecondsUntilAutoPause`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-secondsuntilautopause
         */
        readonly secondsUntilAutoPause?: number;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBClusterParameterGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 */
export interface CfnDBClusterParameterGroupProps {
    /**
     * `AWS::RDS::DBClusterParameterGroup.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-description
     */
    readonly description: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Family`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-family
     */
    readonly family: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Parameters`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-parameters
     */
    readonly parameters: any | cdk.IResolvable;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBClusterParameterGroup`
 *
 * @cloudformationResource AWS::RDS::DBClusterParameterGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 */
export declare class CfnDBClusterParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBClusterParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDBClusterParameterGroup;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-description
     */
    description: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Family`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-family
     */
    family: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Parameters`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-parameters
     */
    parameters: any | cdk.IResolvable;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBClusterParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterParameterGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBInstance`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 */
export interface CfnDBInstanceProps {
    /**
     * `AWS::RDS::DBInstance.DBInstanceClass`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceclass
     */
    readonly dbInstanceClass: string;
    /**
     * `AWS::RDS::DBInstance.AllocatedStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allocatedstorage
     */
    readonly allocatedStorage?: string;
    /**
     * `AWS::RDS::DBInstance.AllowMajorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allowmajorversionupgrade
     */
    readonly allowMajorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AssociatedRoles`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-associatedroles
     */
    readonly associatedRoles?: Array<CfnDBInstance.DBInstanceRoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AutoMinorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-autominorversionupgrade
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::RDS::DBInstance.BackupRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-backupretentionperiod
     */
    readonly backupRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBInstance.CACertificateIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-cacertificateidentifier
     */
    readonly caCertificateIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.CharacterSetName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-charactersetname
     */
    readonly characterSetName?: string;
    /**
     * `AWS::RDS::DBInstance.CopyTagsToSnapshot`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-copytagstosnapshot
     */
    readonly copyTagsToSnapshot?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.DBClusterIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbclusteridentifier
     */
    readonly dbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBInstanceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceidentifier
     */
    readonly dbInstanceIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbname
     */
    readonly dbName?: string;
    /**
     * `AWS::RDS::DBInstance.DBParameterGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbparametergroupname
     */
    readonly dbParameterGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.DBSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups
     */
    readonly dbSecurityGroups?: string[];
    /**
     * `AWS::RDS::DBInstance.DBSnapshotIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier
     */
    readonly dbSnapshotIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBSubnetGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsubnetgroupname
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.DeleteAutomatedBackups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deleteautomatedbackups
     */
    readonly deleteAutomatedBackups?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.DeletionProtection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deletionprotection
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.Domain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domain
     */
    readonly domain?: string;
    /**
     * `AWS::RDS::DBInstance.DomainIAMRoleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domainiamrolename
     */
    readonly domainIamRoleName?: string;
    /**
     * `AWS::RDS::DBInstance.EnableCloudwatchLogsExports`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports
     */
    readonly enableCloudwatchLogsExports?: string[];
    /**
     * `AWS::RDS::DBInstance.EnableIAMDatabaseAuthentication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication
     */
    readonly enableIamDatabaseAuthentication?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.EnablePerformanceInsights`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights
     */
    readonly enablePerformanceInsights?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.Engine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engine
     */
    readonly engine?: string;
    /**
     * `AWS::RDS::DBInstance.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::DBInstance.Iops`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-iops
     */
    readonly iops?: number;
    /**
     * `AWS::RDS::DBInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::RDS::DBInstance.LicenseModel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-licensemodel
     */
    readonly licenseModel?: string;
    /**
     * `AWS::RDS::DBInstance.MasterUsername`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masterusername
     */
    readonly masterUsername?: string;
    /**
     * `AWS::RDS::DBInstance.MasterUserPassword`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masteruserpassword
     */
    readonly masterUserPassword?: string;
    /**
     * `AWS::RDS::DBInstance.MaxAllocatedStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-maxallocatedstorage
     */
    readonly maxAllocatedStorage?: number;
    /**
     * `AWS::RDS::DBInstance.MonitoringInterval`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringinterval
     */
    readonly monitoringInterval?: number;
    /**
     * `AWS::RDS::DBInstance.MonitoringRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringrolearn
     */
    readonly monitoringRoleArn?: string;
    /**
     * `AWS::RDS::DBInstance.MultiAZ`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-multiaz
     */
    readonly multiAz?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.OptionGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-optiongroupname
     */
    readonly optionGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsKMSKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightskmskeyid
     */
    readonly performanceInsightsKmsKeyId?: string;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod
     */
    readonly performanceInsightsRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBInstance.Port`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port
     */
    readonly port?: string;
    /**
     * `AWS::RDS::DBInstance.PreferredBackupWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredbackupwindow
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::RDS::DBInstance.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredmaintenancewindow
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::RDS::DBInstance.ProcessorFeatures`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-processorfeatures
     */
    readonly processorFeatures?: Array<CfnDBInstance.ProcessorFeatureProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.PromotionTier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-promotiontier
     */
    readonly promotionTier?: number;
    /**
     * `AWS::RDS::DBInstance.PubliclyAccessible`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-publiclyaccessible
     */
    readonly publiclyAccessible?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.SourceDBInstanceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier
     */
    readonly sourceDbInstanceIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.SourceRegion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourceregion
     */
    readonly sourceRegion?: string;
    /**
     * `AWS::RDS::DBInstance.StorageEncrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storageencrypted
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.StorageType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storagetype
     */
    readonly storageType?: string;
    /**
     * `AWS::RDS::DBInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::RDS::DBInstance.Timezone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-timezone
     */
    readonly timezone?: string;
    /**
     * `AWS::RDS::DBInstance.UseDefaultProcessorFeatures`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures
     */
    readonly useDefaultProcessorFeatures?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.VPCSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-vpcsecuritygroups
     */
    readonly vpcSecurityGroups?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`
 *
 * @cloudformationResource AWS::RDS::DBInstance
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 */
export declare class CfnDBInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDBInstance;
    /**
     * @cloudformationAttribute Endpoint.Address
     */
    readonly attrEndpointAddress: string;
    /**
     * @cloudformationAttribute Endpoint.Port
     */
    readonly attrEndpointPort: string;
    /**
     * `AWS::RDS::DBInstance.DBInstanceClass`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceclass
     */
    dbInstanceClass: string;
    /**
     * `AWS::RDS::DBInstance.AllocatedStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allocatedstorage
     */
    allocatedStorage: string | undefined;
    /**
     * `AWS::RDS::DBInstance.AllowMajorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allowmajorversionupgrade
     */
    allowMajorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AssociatedRoles`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-associatedroles
     */
    associatedRoles: Array<CfnDBInstance.DBInstanceRoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AutoMinorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-autominorversionupgrade
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::RDS::DBInstance.BackupRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-backupretentionperiod
     */
    backupRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBInstance.CACertificateIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-cacertificateidentifier
     */
    caCertificateIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.CharacterSetName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-charactersetname
     */
    characterSetName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.CopyTagsToSnapshot`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-copytagstosnapshot
     */
    copyTagsToSnapshot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.DBClusterIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbclusteridentifier
     */
    dbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBInstanceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceidentifier
     */
    dbInstanceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbname
     */
    dbName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBParameterGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbparametergroupname
     */
    dbParameterGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups
     */
    dbSecurityGroups: string[] | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSnapshotIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier
     */
    dbSnapshotIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSubnetGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsubnetgroupname
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DeleteAutomatedBackups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deleteautomatedbackups
     */
    deleteAutomatedBackups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.DeletionProtection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deletionprotection
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.Domain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domain
     */
    domain: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DomainIAMRoleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domainiamrolename
     */
    domainIamRoleName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.EnableCloudwatchLogsExports`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports
     */
    enableCloudwatchLogsExports: string[] | undefined;
    /**
     * `AWS::RDS::DBInstance.EnableIAMDatabaseAuthentication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication
     */
    enableIamDatabaseAuthentication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.EnablePerformanceInsights`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights
     */
    enablePerformanceInsights: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.Engine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engine
     */
    engine: string | undefined;
    /**
     * `AWS::RDS::DBInstance.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::DBInstance.Iops`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-iops
     */
    iops: number | undefined;
    /**
     * `AWS::RDS::DBInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBInstance.LicenseModel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-licensemodel
     */
    licenseModel: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MasterUsername`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masterusername
     */
    masterUsername: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MasterUserPassword`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masteruserpassword
     */
    masterUserPassword: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MaxAllocatedStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-maxallocatedstorage
     */
    maxAllocatedStorage: number | undefined;
    /**
     * `AWS::RDS::DBInstance.MonitoringInterval`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringinterval
     */
    monitoringInterval: number | undefined;
    /**
     * `AWS::RDS::DBInstance.MonitoringRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringrolearn
     */
    monitoringRoleArn: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MultiAZ`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-multiaz
     */
    multiAz: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.OptionGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-optiongroupname
     */
    optionGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsKMSKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightskmskeyid
     */
    performanceInsightsKmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod
     */
    performanceInsightsRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBInstance.Port`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port
     */
    port: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PreferredBackupWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredbackupwindow
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredmaintenancewindow
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::RDS::DBInstance.ProcessorFeatures`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-processorfeatures
     */
    processorFeatures: Array<CfnDBInstance.ProcessorFeatureProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.PromotionTier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-promotiontier
     */
    promotionTier: number | undefined;
    /**
     * `AWS::RDS::DBInstance.PubliclyAccessible`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-publiclyaccessible
     */
    publiclyAccessible: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.SourceDBInstanceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier
     */
    sourceDbInstanceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.SourceRegion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourceregion
     */
    sourceRegion: string | undefined;
    /**
     * `AWS::RDS::DBInstance.StorageEncrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storageencrypted
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.StorageType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storagetype
     */
    storageType: string | undefined;
    /**
     * `AWS::RDS::DBInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::RDS::DBInstance.Timezone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-timezone
     */
    timezone: string | undefined;
    /**
     * `AWS::RDS::DBInstance.UseDefaultProcessorFeatures`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures
     */
    useDefaultProcessorFeatures: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.VPCSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-vpcsecuritygroups
     */
    vpcSecurityGroups: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDBInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html
     */
    interface DBInstanceRoleProperty {
        /**
         * `CfnDBInstance.DBInstanceRoleProperty.FeatureName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-featurename
         */
        readonly featureName: string;
        /**
         * `CfnDBInstance.DBInstanceRoleProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnDBInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html
     */
    interface ProcessorFeatureProperty {
        /**
         * `CfnDBInstance.ProcessorFeatureProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-name
         */
        readonly name?: string;
        /**
         * `CfnDBInstance.ProcessorFeatureProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-value
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBParameterGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html
 */
export interface CfnDBParameterGroupProps {
    /**
     * `AWS::RDS::DBParameterGroup.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description
     */
    readonly description: string;
    /**
     * `AWS::RDS::DBParameterGroup.Family`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family
     */
    readonly family: string;
    /**
     * `AWS::RDS::DBParameterGroup.Parameters`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::RDS::DBParameterGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBParameterGroup`
 *
 * @cloudformationResource AWS::RDS::DBParameterGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html
 */
export declare class CfnDBParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDBParameterGroup;
    /**
     * `AWS::RDS::DBParameterGroup.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description
     */
    description: string;
    /**
     * `AWS::RDS::DBParameterGroup.Family`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family
     */
    family: string;
    /**
     * `AWS::RDS::DBParameterGroup.Parameters`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBParameterGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBParameterGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBSecurityGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
export interface CfnDBSecurityGroupProps {
    /**
     * `AWS::RDS::DBSecurityGroup.DBSecurityGroupIngress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-dbsecuritygroupingress
     */
    readonly dbSecurityGroupIngress: Array<CfnDBSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBSecurityGroup.GroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-groupdescription
     */
    readonly groupDescription: string;
    /**
     * `AWS::RDS::DBSecurityGroup.EC2VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-ec2vpcid
     */
    readonly ec2VpcId?: string;
    /**
     * `AWS::RDS::DBSecurityGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
export declare class CfnDBSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDBSecurityGroup;
    /**
     * `AWS::RDS::DBSecurityGroup.DBSecurityGroupIngress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-dbsecuritygroupingress
     */
    dbSecurityGroupIngress: Array<CfnDBSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBSecurityGroup.GroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-groupdescription
     */
    groupDescription: string;
    /**
     * `AWS::RDS::DBSecurityGroup.EC2VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-ec2vpcid
     */
    ec2VpcId: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSecurityGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDBSecurityGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html
     */
    interface IngressProperty {
        /**
         * `CfnDBSecurityGroup.IngressProperty.CIDRIP`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-cidrip
         */
        readonly cidrip?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupid
         */
        readonly ec2SecurityGroupId?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupname
         */
        readonly ec2SecurityGroupName?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupOwnerId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupownerid
         */
        readonly ec2SecurityGroupOwnerId?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBSecurityGroupIngress`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 */
export interface CfnDBSecurityGroupIngressProps {
    /**
     * `AWS::RDS::DBSecurityGroupIngress.DBSecurityGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-dbsecuritygroupname
     */
    readonly dbSecurityGroupName: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.CIDRIP`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-cidrip
     */
    readonly cidrip?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupid
     */
    readonly ec2SecurityGroupId?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupname
     */
    readonly ec2SecurityGroupName?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupOwnerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupownerid
     */
    readonly ec2SecurityGroupOwnerId?: string;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroupIngress`
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroupIngress
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 */
export declare class CfnDBSecurityGroupIngress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroupIngress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDBSecurityGroupIngress;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.DBSecurityGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-dbsecuritygroupname
     */
    dbSecurityGroupName: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.CIDRIP`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-cidrip
     */
    cidrip: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupid
     */
    ec2SecurityGroupId: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupname
     */
    ec2SecurityGroupName: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupOwnerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupownerid
     */
    ec2SecurityGroupOwnerId: string | undefined;
    /**
     * Create a new `AWS::RDS::DBSecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSecurityGroupIngressProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBSubnetGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html
 */
export interface CfnDBSubnetGroupProps {
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupdescription
     */
    readonly dbSubnetGroupDescription: string;
    /**
     * `AWS::RDS::DBSubnetGroup.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupname
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBSubnetGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBSubnetGroup`
 *
 * @cloudformationResource AWS::RDS::DBSubnetGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html
 */
export declare class CfnDBSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDBSubnetGroup;
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupdescription
     */
    dbSubnetGroupDescription: string;
    /**
     * `AWS::RDS::DBSubnetGroup.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupname
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBSubnetGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSubnetGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::EventSubscription`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 */
export interface CfnEventSubscriptionProps {
    /**
     * `AWS::RDS::EventSubscription.SnsTopicArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-snstopicarn
     */
    readonly snsTopicArn: string;
    /**
     * `AWS::RDS::EventSubscription.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::EventSubscription.EventCategories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-eventcategories
     */
    readonly eventCategories?: string[];
    /**
     * `AWS::RDS::EventSubscription.SourceIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourceids
     */
    readonly sourceIds?: string[];
    /**
     * `AWS::RDS::EventSubscription.SourceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourcetype
     */
    readonly sourceType?: string;
}
/**
 * A CloudFormation `AWS::RDS::EventSubscription`
 *
 * @cloudformationResource AWS::RDS::EventSubscription
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 */
export declare class CfnEventSubscription extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::EventSubscription";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnEventSubscription;
    /**
     * `AWS::RDS::EventSubscription.SnsTopicArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-snstopicarn
     */
    snsTopicArn: string;
    /**
     * `AWS::RDS::EventSubscription.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::EventSubscription.EventCategories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-eventcategories
     */
    eventCategories: string[] | undefined;
    /**
     * `AWS::RDS::EventSubscription.SourceIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourceids
     */
    sourceIds: string[] | undefined;
    /**
     * `AWS::RDS::EventSubscription.SourceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourcetype
     */
    sourceType: string | undefined;
    /**
     * Create a new `AWS::RDS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSubscriptionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::OptionGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
export interface CfnOptionGroupProps {
    /**
     * `AWS::RDS::OptionGroup.EngineName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename
     */
    readonly engineName: string;
    /**
     * `AWS::RDS::OptionGroup.MajorEngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion
     */
    readonly majorEngineVersion: string;
    /**
     * `AWS::RDS::OptionGroup.OptionConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations
     */
    readonly optionConfigurations: Array<CfnOptionGroup.OptionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::OptionGroup.OptionGroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription
     */
    readonly optionGroupDescription: string;
    /**
     * `AWS::RDS::OptionGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`
 *
 * @cloudformationResource AWS::RDS::OptionGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
export declare class CfnOptionGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::OptionGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnOptionGroup;
    /**
     * `AWS::RDS::OptionGroup.EngineName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename
     */
    engineName: string;
    /**
     * `AWS::RDS::OptionGroup.MajorEngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion
     */
    majorEngineVersion: string;
    /**
     * `AWS::RDS::OptionGroup.OptionConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations
     */
    optionConfigurations: Array<CfnOptionGroup.OptionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::OptionGroup.OptionGroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription
     */
    optionGroupDescription: string;
    /**
     * `AWS::RDS::OptionGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::OptionGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOptionGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnOptionGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html
     */
    interface OptionConfigurationProperty {
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.DBSecurityGroupMemberships`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-dbsecuritygroupmemberships
         */
        readonly dbSecurityGroupMemberships?: string[];
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-optionname
         */
        readonly optionName: string;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-optionsettings
         */
        readonly optionSettings?: Array<CfnOptionGroup.OptionSettingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfiguration-optionversion
         */
        readonly optionVersion?: string;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.Port`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-port
         */
        readonly port?: number;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.VpcSecurityGroupMemberships`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-vpcsecuritygroupmemberships
         */
        readonly vpcSecurityGroupMemberships?: string[];
    }
}
export declare namespace CfnOptionGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html
     */
    interface OptionSettingProperty {
        /**
         * `CfnOptionGroup.OptionSettingProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html#cfn-rds-optiongroup-optionconfigurations-optionsettings-name
         */
        readonly name?: string;
        /**
         * `CfnOptionGroup.OptionSettingProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html#cfn-rds-optiongroup-optionconfigurations-optionsettings-value
         */
        readonly value?: string;
    }
}
