"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const notifs = require("../../aws-s3-notifications"); // Automatically re-written from '@aws-cdk/aws-s3-notifications'
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
    }
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
//# sourceMappingURL=data:application/json;base64,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