"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use a SQS queue as a Lambda destination
 */
class SqsDestination {
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        // deduplicated automatically
        this.queue.grantSendMessages(fn);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDestination = SqsDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLGNBQWM7SUFDdkIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTtJQUM5QyxDQUFDO0lBQ0Q7O09BRUc7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxFQUFvQixFQUFFLFFBQW9DO1FBQ3JGLDZCQUE2QjtRQUM3QixJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQ2pDLE9BQU87WUFDSCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ25DLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFiRCx3Q0FhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tIFwiLi4vLi4vYXdzLWxhbWJkYVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSdcbmltcG9ydCAqIGFzIHNxcyBmcm9tIFwiLi4vLi4vYXdzLXNxc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNxcydcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuLyoqXG4gKiBVc2UgYSBTUVMgcXVldWUgYXMgYSBMYW1iZGEgZGVzdGluYXRpb25cbiAqL1xuZXhwb3J0IGNsYXNzIFNxc0Rlc3RpbmF0aW9uIGltcGxlbWVudHMgbGFtYmRhLklEZXN0aW5hdGlvbiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBxdWV1ZTogc3FzLklRdWV1ZSkge1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIGEgZGVzdGluYXRpb24gY29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBmbjogbGFtYmRhLklGdW5jdGlvbiwgX29wdGlvbnM/OiBsYW1iZGEuRGVzdGluYXRpb25PcHRpb25zKTogbGFtYmRhLkRlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICAgICAgLy8gZGVkdXBsaWNhdGVkIGF1dG9tYXRpY2FsbHlcbiAgICAgICAgdGhpcy5xdWV1ZS5ncmFudFNlbmRNZXNzYWdlcyhmbik7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBkZXN0aW5hdGlvbjogdGhpcy5xdWV1ZS5xdWV1ZUFybixcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=