"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * A principal to allow access to a key if it's being used through another AWS service
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
//# sourceMappingURL=data:application/json;base64,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