"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function arrayDiff(oldValues, newValues) {
    const deletes = new Set(oldValues);
    const adds = new Set();
    for (const v of new Set(newValues)) {
        if (deletes.has(v)) {
            deletes.delete(v);
        }
        else {
            adds.add(v);
        }
    }
    return {
        adds: Array.from(adds),
        deletes: Array.from(deletes),
    };
}
exports.arrayDiff = arrayDiff;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGlmZi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRpZmYudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxTQUFnQixTQUFTLENBQUMsU0FBbUIsRUFBRSxTQUFtQjtJQUM5RCxNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNuQyxNQUFNLElBQUksR0FBRyxJQUFJLEdBQUcsRUFBVSxDQUFDO0lBQy9CLEtBQUssTUFBTSxDQUFDLElBQUksSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLEVBQUU7UUFDaEMsSUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQ2hCLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDckI7YUFDSTtZQUNELElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDZjtLQUNKO0lBQ0QsT0FBTztRQUNILElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztRQUN0QixPQUFPLEVBQUUsS0FBSyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7S0FDL0IsQ0FBQztBQUNOLENBQUM7QUFmRCw4QkFlQyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBmdW5jdGlvbiBhcnJheURpZmYob2xkVmFsdWVzOiBzdHJpbmdbXSwgbmV3VmFsdWVzOiBzdHJpbmdbXSkge1xuICAgIGNvbnN0IGRlbGV0ZXMgPSBuZXcgU2V0KG9sZFZhbHVlcyk7XG4gICAgY29uc3QgYWRkcyA9IG5ldyBTZXQ8c3RyaW5nPigpO1xuICAgIGZvciAoY29uc3QgdiBvZiBuZXcgU2V0KG5ld1ZhbHVlcykpIHtcbiAgICAgICAgaWYgKGRlbGV0ZXMuaGFzKHYpKSB7XG4gICAgICAgICAgICBkZWxldGVzLmRlbGV0ZSh2KTtcbiAgICAgICAgfVxuICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgIGFkZHMuYWRkKHYpO1xuICAgICAgICB9XG4gICAgfVxuICAgIHJldHVybiB7XG4gICAgICAgIGFkZHM6IEFycmF5LmZyb20oYWRkcyksXG4gICAgICAgIGRlbGV0ZXM6IEFycmF5LmZyb20oZGVsZXRlcyksXG4gICAgfTtcbn1cbiJdfQ==