"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Obtain the Role for the CloudWatch event
 *
 * If a role already exists, it will be returned. This ensures that if multiple
 * events have the same target, they will share a role.
 */
function singletonEventRole(scope, policyStatements) {
    const id = 'EventsRole';
    const existing = scope.node.tryFindChild(id);
    if (existing) {
        return existing;
    }
    const role = new iam.Role(scope, id, {
        assumedBy: new iam.ServicePrincipal('events.amazonaws.com'),
    });
    policyStatements.forEach(role.addToPolicy.bind(role));
    return role;
}
exports.singletonEventRole = singletonEventRole;
/**
 * Allows a Lambda function to be called from a rule
 */
function addLambdaPermission(rule, handler) {
    const permissionId = `AllowEventRule${rule.node.uniqueId}`;
    if (!handler.permissionsNode.tryFindChild(permissionId)) {
        handler.addPermission(permissionId, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('events.amazonaws.com'),
            sourceArn: rule.ruleArn,
        });
    }
}
exports.addLambdaPermission = addLambdaPermission;
//# sourceMappingURL=data:application/json;base64,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