"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Use a StepFunctions state machine as a target for AWS CloudWatch event rules.
 */
class SfnStateMachine {
    constructor(machine, props = {}) {
        this.machine = machine;
        this.props = props;
    }
    /**
     * Returns a properties that are used in an Rule to trigger this State Machine
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sns-permissions
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.machine.stateMachineArn,
            role: util_1.singletonEventRole(this.machine, [new iam.PolicyStatement({
                    actions: ['states:StartExecution'],
                    resources: [this.machine.stateMachineArn],
                })]),
            input: this.props.input,
            targetResource: this.machine,
        };
    }
}
exports.SfnStateMachine = SfnStateMachine;
//# sourceMappingURL=data:application/json;base64,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