"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("./util");
/**
 * Use an AWS Lambda function as an event rule target.
 */
class LambdaFunction {
    constructor(handler, props = {}) {
        this.handler = handler;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Lambda as a
     * result from a CloudWatch event.
     */
    bind(rule, _id) {
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, this.handler);
        return {
            id: '',
            arn: this.handler.functionArn,
            input: this.props.event,
            targetResource: this.handler,
        };
    }
}
exports.LambdaFunction = LambdaFunction;
//# sourceMappingURL=data:application/json;base64,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