"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Allows the pipeline to be used as a CloudWatch event rule target.
 */
class CodePipeline {
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
    }
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.pipeline.pipelineArn,
            role: this.options.eventRole || util_1.singletonEventRole(this.pipeline, [new iam.PolicyStatement({
                    resources: [this.pipeline.pipelineArn],
                    actions: ['codepipeline:StartPipelineExecution'],
                })]),
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
//# sourceMappingURL=data:application/json;base64,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