import * as codebuild from "../../aws-codebuild";
import * as events from "../../aws-events";
/**
 * Customize the CodeBuild Event Target
 */
export interface CodeBuildProjectProps {
    /**
     * The event to send to CodeBuild
     *
     * This will be the payload for the StartBuild API.
     *
     * @default - the entire CloudWatch event
     */
    readonly event?: events.RuleTargetInput;
}
/**
 * Start a CodeBuild build when an AWS CloudWatch events rule is triggered.
 */
export declare class CodeBuildProject implements events.IRuleTarget {
    private readonly project;
    private readonly props;
    constructor(project: codebuild.IProject, props?: CodeBuildProjectProps);
    /**
     * Allows using build projects as event rule targets.
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
