"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:no-console
// eslint-disable-next-line import/no-extraneous-dependencies
const AWS = require("aws-sdk");
async function handler(event) {
    console.log('Event: %j', event);
    console.log('AWS SDK VERSION: ' + AWS.VERSION);
    const awsService = new AWS[event.service](event.apiVersion && { apiVersion: event.apiVersion });
    try {
        const response = await awsService[event.action](event.parameters).promise();
        console.log('Response: %j', response);
    }
    catch (e) {
        console.log(e);
        if (!event.catchErrorPattern || !new RegExp(event.catchErrorPattern).test(e.code)) {
            throw e;
        }
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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