"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * What kind of addresses to allocate to the load balancer
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * Allocate IPv4 addresses
     */
    IpAddressType["IPV4"] = "ipv4";
    /**
     * Allocate both IPv4 and IPv6 addresses
     */
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks
 */
var Protocol;
(function (Protocol) {
    /**
     * HTTP (ALB health checks and NLB health checks)
     */
    Protocol["HTTP"] = "HTTP";
    /**
     * HTTPS (ALB health checks and NLB health checks)
     */
    Protocol["HTTPS"] = "HTTPS";
    /**
     * TCP (NLB, NLB health checks)
     */
    Protocol["TCP"] = "TCP";
    /**
     * TLS (NLB)
     */
    Protocol["TLS"] = "TLS";
    /**
     * UDP (NLB)
     */
    Protocol["UDP"] = "UDP";
    /**
     * Listen to both TCP and UDP on the same port (NLB)
     */
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    /**
     * HTTP
     */
    ApplicationProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS
     */
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 */
var SslPolicy;
(function (SslPolicy) {
    /**
     * The recommended security policy
     */
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    /**
     * Strong forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    /**
     * Forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    /**
     * Forward secrecy ciphers only with TLS1.1 and higher
     */
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    /**
     * Forward secrecy ciphers only
     */
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    /**
     * TLS1.2 only and no SHA ciphers
     */
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    /**
     * TLS1.2 only with all ciphers
     */
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    /**
     * TLS1.1 and higher with all ciphers
     */
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    /**
     * Support for DES-CBC3-SHA
     *
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     */
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers
 */
var TargetType;
(function (TargetType) {
    /**
     * Targets identified by instance ID
     */
    TargetType["INSTANCE"] = "instance";
    /**
     * Targets identified by IP address
     */
    TargetType["IP"] = "ip";
    /**
     * Target is a single Lambda Function
     */
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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